;;;;;;;;;;;;;
; HappyInput
;;;;;;;;;;;;;

$Version = "1.2"
$Date = "April 1, 2011"

; łɋNĂƂ̏
$List = ProcessList("HappyInput.exe")
If $List[0][0] > 1 Then
    MsgBox(48, "sł ...", "łɃEBhEoĂ܂D", 1)
    Exit
EndIf

#Include <GuiEdit.au3>
#Include <WinAPI.au3>

#include <WindowsConstants.au3>
#include <GuiConstantsEx.au3>
#include <UpDownConstants.au3>
#include <GuiListView.au3>

Global $CsType, $BsLen, $ListContinue, $ShowChild

$NoMatches = 1
If @OSVersion = "WIN_7" OR @OSVersion = "WIN_VISTA" Then
    $DispNL = @CRLF
Else
    $DispNL = @CRLF & @CRLF
EndIf

$Handle = ControlGetHandle("[ACTIVE]", "", "")
$ParentWindowHandle = $Handle
$EditWindow = _WinAPI_GetClassName($Handle) & "1"

$ScriptDir = @ScriptDir
If StringLen($ScriptDir) > 3 Then $ScriptDir &= "\"
$IniFile = $ScriptDir & "HappyInput.ini"
If NOT FileExists($IniFile) Then
    MsgBox(4096, "G[", "HappyInput.ini ܂D", 1)
    Exit
EndIf

$EmptyPaste = IniRead($IniFile, "Editor", "EmptyPaste", "")
$Undo       = IniRead($IniFile, "Editor", "Undo",       "")
$LineTop    = IniRead($IniFile, "Editor", "LineTop",    "")
$LineTop2   = IniRead($IniFile, "Editor", "LineTop2",   "")
$LineEnd    = IniRead($IniFile, "Editor", "LineEnd",    "")
$CancelKey  = IniRead($IniFile, "Editor", "Cancel",     "")

$Cmd1 = $CmdLine[1]
$FilePath = ""
$NL = ""

If $Cmd1 = "auto" Then
    $AutoMode = True
    $Sel = _GUICtrlEdit_GetSel($Handle)
    $SelStart = $Sel[0]
    $SelEnd = $Sel[1]
    $SCharIndex = GetLineTopCharIndex($SelStart)
    If $SelStart < $SelEnd Then
        $Type = "string"
        If $SelStart = $SCharIndex Then
            $ECharIndex = GetLineTopCharIndex($SelEnd)
            $FileEnd = False
            If $ECharIndex < $SelEnd Then
                PutCursol($SelEnd)
                ControlSend($Handle, "", "", "{RIGHT}")
                $Sel = _GUICtrlEdit_GetSel($Handle)
                If $Sel[0] = $SelEnd Then $FileEnd = True
            EndIf
            If $SelEnd = $ECharIndex OR $FileEnd Then
                If $FileEnd AND $SCharIndex = $ECharIndex Then
                    $Type = "line-string"
                    If $NL = "" Then SetNL(IniRead($IniFile, "Editor", "NewlineChar", ""))
                Else
                    $Type = "line"
                EndIf
            EndIf
        EndIf
        PutCursol($SelEnd)
        _GUICtrlEdit_SetSel($Handle, $SelStart, $SelEnd)
        $Data = ControlCommand("[ACTIVE]", "", $EditWindow, "GetSelected", "")
    Else
        PutCursol($SelStart)
        If $SelStart = $SCharIndex Then
            $Type = "menu"
        Else
            $Type = "normal"
            _GUICtrlEdit_SetSel($Handle, $SCharIndex, $SelStart)
            $Data = ControlCommand("[ACTIVE]", "", $EditWindow, "GetSelected", "")
            ControlSend($Handle, "", "", $CancelKey)
        EndIf
        $RightIsNewtLine = CheckRight()
        PutCursol($SelStart)
        If $CmdLine[0] > 1 Then
            $FilePath = $CmdLine[2]
            If $FilePath = "-" Then SetFileNameFromTitleBar()
        EndIf
    EndIf
Else
    $AutoMode = False
    SetNL($Cmd1)
    $Type = $CmdLine[2]
    If $Type = "normal" OR $Type = "menu" Then
        $RightIsNewtLine = ($CmdLine[3] = 1)
        If $CmdLine[0] > 3 Then $FilePath = $CmdLine[4]
    EndIf
    $Data = ClipGet()
    ClipPut("")
EndIf

If $Type = "line-string" Then
    $YN = MsgBox(4, "mF", "̑IłH", 0, $Handle)
    If $YN = 6 Then      ; YES
        $Type = "string"
    Else                 ; NO
        $Type = "line"
    EndIf
EndIf

$WDir = ""
If $FilePath <> "" Then SetWorkingDirectory()
If $WDir = "" Then $FilePath = ""

$DicDir = $ScriptDir & IniRead($IniFile, "Dictionary", "Directory", "") & "\"
If NOT FileExists($DicDir) Then
    MsgBox(4096, "G[", "fBNg܂D", 1)
    Exit
EndIf

$NLLen = StringLen($NL)

$MaxMaxCs      = 1000 ; Ɏc cs ̍ől

$MaxMaxCsA     =   10 ; Ɏc section ^ cs ̍őliIj[Łj
$MaxMaxCsB     =   10 ; Ɏc large ^   cs ̍őliIj[Łj
$MaxMaxEnv     =   10 ; Ɏc           ̍őliIj[Łj
$MaxIndent     =   20 ; I͈͂̃Cfg̍ől     iIj[Łj

$MaxEnvIndent  =    4 ; ubN̒̃Cfg̍ől
$MaxLeftIndent =   50 ; Cfg̍ől
$MaxCsLen      =   30 ; cs Ƃēo^ł镶̍ő̒
$MaxUsedEnv    =   20 ; Ɏc̐
$MaxLabels     =  200 ; o^郉x̍ő吔

$DicType     = IniRead($IniFile, "Dictionary", "Type",        "")
$UseAt       = IniRead($IniFile, "Dictionary", "UseAt",       "")
$Save        = IniRead($IniFile, "Dictionary", "Save",        "")
$ReUse       = IniRead($IniFile, "Dictionary", "ReUse",       "")
$MinCsLen    = IniRead($IniFile, "Dictionary", "MinCsLen",    "")
If $MinCsLen < 3 Then $MinCsLen = 3
$MaxShowCs   = IniRead($IniFile, "Dictionary", "MaxShowCs",   "")
If $MaxShowCs < 9 Then $MaxShowCs = 9
$Shortcut    = IniRead($IniFile, "Shortcut",   "Key",         "")
$MaxCs       = IniRead($IniFile, "History",    "Cs",          "")
$MaxCsA      = IniRead($IniFile, "History",    "CsA",         "")
$MaxCsB      = IniRead($IniFile, "History",    "CsB",         "")
$MaxEnv      = IniRead($IniFile, "History",    "Env",         "")
If $MaxCs  > $MaxMaxCs  Then $MaxCs  = $MaxMaxCs
If $MaxCsA > $MaxMaxCsA Then $MaxCsA = $MaxMaxCsA
If $MaxCsB > $MaxMaxCsB Then $MaxCsB = $MaxMaxCsB
If $MaxEnv > $MaxMaxEnv Then $MaxEnv = $MaxMaxEnv
$CommentType = IniRead($IniFile, "Document",   "CommentType", "")
$EnvIndent   = IniRead($IniFile, "Document",   "Indent",      "")
$ClassName   = IniRead($IniFile, "Document",   "ClassName",   "")
$AddSpace    = SetSpaces($EnvIndent)
$RowNum      = IniRead($IniFile, "Tabular",    "RowNum",      "")
$ColNum      = IniRead($IniFile, "Tabular",    "ColumnNum",   "")
$RowInfo     = IniRead($IniFile, "Tabular",    "Row",         "")
$ColInfo     = IniRead($IniFile, "Tabular",    "Column",      "")
$ArrayRowNum = IniRead($IniFile, "Array",      "RowNum",      "")
$ArrayColNum = IniRead($IniFile, "Array",      "ColumnNum",   "")
$AddMenuTop  = IniRead($IniFile, "Script",     "AddMenuTop",  "")
$Sort        = IniRead($IniFile, "Script",     "Sort",        "")
If $Sort = 1 Then
    $ListViewOption = $LVS_LIST
Else
    $ListViewOption = $LVS_LIST + $LVS_SORTASCENDING
EndIf
$Delay       = IniRead($IniFile, "Script",     "Delay",       "")
$Editor      = IniRead($IniFile, "Editor",     "Path",        "")
If StringMid($Editor, 2, 1) <> ":" Then ; USB ̏ꍇ
    $Editor = StringLeft(@ScriptDir, StringInStr(@ScriptDir, "\", 0, -1)) & $Editor
EndIf
$SaveKey     = IniRead($IniFile, "Editor",     "Save",        "")
$Paste       = IniRead($IniFile, "Editor",     "Paste",       "")

If $DicType < 3 Then
    $CsDic    = $DicDir & "Cs.dic"
    $AtDic    = $DicDir & "CsAt.dic"
    $UserDic  = $DicDir & "Cs.usr"
    $UsedDic  = $DicDir & "Used.usr"
Else
    $CsDic    = $DicDir & "Plain.dic"
    $AtDic    = $DicDir & "PlainAt.dic"
    $UserDic  = $DicDir & "Plain.pusr"
    $UsedDic  = $DicDir & "Used.pusr"
EndIf
$TeXDic       = $DicDir & "TeX.dic"
$CsSubDic     = $DicDir & "CsSub.dic"
$CsOtherDic   = $DicDir & "CsOther.dic"
$CsAMSDic     = $DicDir & "CsAMS.dic"
$EnvDic       = $DicDir & "Env.dic"
$EnvAMSDic    = $DicDir & "EnvAMS.dic"
$EnvOtherDic  = $DicDir & "EnvOther.dic"
$EnvUserDic   = $DicDir & "Env.usr"
$UsedEnvDic   = $DicDir & "UsedEnv.usr"
$GreekDic     = $DicDir & "Greek.dic"
$SymbolDic    = $DicDir & "Symbol.dic"
$AliasDic     = $DicDir & "Alias.dat"
$DefFile      = $DicDir & "Completion.def"
$HisFile      = $DicDir & "History.his"
$TemplateFile = $DicDir & "Template.dat"
$LabelData    = $DicDir & "Label.dat"

If $Type = "menu" Then
    $LeftSpace = ""
    Setting()
EndIf

If $Type = "line" Then LineSelection()

If $Type = "string" Then StringSelection()

If $MaxCs > 0 Then
    $ss = StringRight($Data, 4)
    $tt = StringTrimRight($ss, 3)
    $ss = StringRight($ss, 3)
    If $tt <> "\" AND StringLeft($ss, 2) = "\\" Then
        $tt = StringRight($ss, 1)
        If StringIsDigit($tt) Then
            If $tt > 0 AND $tt < 6 Then
                GetAllData($UsedEnvDic, -$tt, 2)
                Exit
            EndIf
        EndIf
    EndIf
    $ss = StringRight($Data, 2)
    If StringLeft($ss, 1) = "\" Then
        $tt = StringRight($ss, 1)
        If StringIsDigit($tt) Then
            If $tt > 0 AND $tt < 6 Then
                GetAllData($UsedDic, -$tt, 1)
                Exit
            EndIf
        EndIf
    EndIf
    If StringRight($Data, 3) = "\\\" Then
        GetAllData($UsedDic, $MaxShowCs, 1)
        Exit
    EndIf
    If $DicType < 3 AND StringRight($Data, 2) = "\\" Then
        GetAllData($UsedEnvDic, $MaxShowCs, 2)
        Exit
    EndIf
    If StringRight($Data, 1) = "\" Then
        GetAllData($UsedDic, $MaxShowCs, 1)
        Exit
    EndIf
    If $DicType < 3 AND $Data = SetSpaces(StringLen($Data)) Then
        GetAllData($UsedEnvDic, $MaxShowCs, 0)
        Exit
    EndIf
EndIf
If $DicType < 3 Then
    If StringRight($Data, 2) = "\[" Then
        SetLeftIndent(2)
        If $NLStart Then WriteString("%L2%%H%R2%")
        WriteString("%J%M\]%N%U2%%>")
        Exit
    EndIf
    If StringRight($Data, 2) = "\(" Then
        SimpleWrite("  \)")
        ControlSend($Handle, "", "", "{LEFT 3}")
        Exit
    EndIf
    If $WDir <> "" AND StringRight($Data, 1) = "}" Then
        $LabelName = StringRegExp($Data, "\\label\{([^\{\}]+)\}$", 3)
        If $LabelName <> $NoMatches Then AddLabel($LabelName[0])
        Exit
    EndIf
ElseIf StringRight($Data, 2) = "$$" Then
    WriteString("$$%N%L3%")
    Exit
EndIf
Switch StringRight($Data, 1)
    Case "$"
        SimpleWrite("$")
        ControlSend($Handle, "", "", "{LEFT}")
        Exit
    Case ","
        GetAllData($AliasDic, 300, -1)
        Exit
    Case ":"
        GetAllData($GreekDic, 50, -2)
        Exit
    Case ";"
        GetAllData($SymbolDic, 300, -3)
        Exit
EndSwitch

$Result = StringRegExp($Data, "(?:(?:(?:^|^.*[^\\])(\\{1,3}))|^ *)(([a-zA-Z@\-]+)(/)?(\*)?)$", 3)
If $Result <> $NoMatches Then
    $CsType = StringLen($Result[0])
    $BsLen = StringLen($Result[1])
    If $CsType = 3 Then $CsType = 1
    If $DicType = 3 AND $CsType <> 1 Then Exit
    SetLeftIndent($BsLen + $CsType)
    If $CsType = 1 Then
        If StringInStr($Result[2], "@") > 0 Then $UseAt = "AtOnly"
        If $ReUse = "Yes" Then
            SearchCsStart($Result, 2, -1)
        Else
            SearchCsStart($Result, 2, 0)
        EndIf
    Else
        If StringInStr($Result[2], "@") > 0 Then Exit
        If $CsType = 2 Then $BsLen += 2
        $UseAt = "No"
        SearchCsStart($Result, 2, 0)
    EndIf
Else
    $CsType = 1
    $Result = StringRegExp($Data, ":([a-zA-Z]+)$", 3)
    If $Result <> $NoMatches Then
        $BsLen = StringLen($Result[0]) + 1
        $ss = Search($Result[0], $GreekDic)
        If $ss <> "" Then
            SimpleReplace($ss)
            If $MaxCs > 0 Then AddToUsedDic(StringTrimLeft($ss,1), "")
        EndIf
    Else
        $Result = StringRegExp($Data, "\;([!-+\--:<-~]+)$", 3)
        If $Result <> $NoMatches Then
            $BsLen = StringLen($Result[0]) + 1
            $ss = Search($Result[0], $SymbolDic)
            If $ss <> "" Then
                Replace($ss)
                $tt = ""
                If StringRight($ss, 1) = "}" Then
                    ControlSend($Handle, "", "", "{LEFT}")
                    $ss = StringTrimRight($ss, 2)
                    $tt = @TAB & @TAB & "%arg1"
                EndIf
                If $MaxCs > 0 Then AddToUsedDic(StringTrimLeft($ss, 1), $tt)
            EndIf
        Else
            $Result = StringRegExp($Data, ",([a-zA-Z][a-zA-Z0-9]*)$", 3)
            If $Result <> $NoMatches Then
                $BsLen = StringLen($Result[0]) + 1
                $ss = Search($Result[0], $AliasDic)
                If $ss <> "" Then
                    SetLeftIndent($BsLen)
                    Replace($ss)
                EndIf
            EndIf
        EndIf
    EndIf
EndIf

Exit

; ==========================================================================

; GfBbgRg[bN / AbN
Func Lock()
    ControlDisable($Handle, "", "")
EndFunc

Func Unlock()
    ControlEnable($Handle, "", "")
    ControlFocus($Handle, "", $EditWindow)
EndFunc

; sR[hZbg ---------------------------------------------------
Func SetNL($s)
    Switch $s
        Case "CRLF"
            $NL = @CRLF
        Case "CR"
            $NL = @CR
        Case "LF"
            $NL = @LF
    EndSwitch
EndFunc

; CharIndex $x ̘_s CharIndex 𓾂 -------------------------------
Func GetLineTopCharIndex($x)
    PutCursol($x)
    Do
        ControlSend($Handle, "", "", $LineTop2)
        $Sel = _GUICtrlEdit_GetSel($Handle)
        $a = $Sel[0]
        If $a = 0 Then ExitLoop
        ControlSend($Handle, "", "", "+{LEFT}")
        $s = ControlCommand("[ACTIVE]", "", $EditWindow, "GetSelected", "")
        ControlSend($Handle, "", "", $CancelKey)
    Until $s = @CRLF OR $s = @CR OR $s = @LF
    If $a > 0 AND $NL = "" Then $NL = $s
    Return $a
EndFunc

; CharIndex $x ̈ʒuɃJ[\u --------------------------------------
Func PutCursol($x)
    _GUICtrlEdit_InsertText($Handle, "", $x)
    If $EmptyPaste = "Yes" Then ControlSend($Handle, "", "", $Undo)
EndFunc

; J[\ʒủEs -------------------------------------------------
Func CheckRight()
    $RINL = False
    Do
        ControlSend($Handle, "", "", $LineEnd)
        $Sel = _GUICtrlEdit_GetSel($Handle)
        $a = $Sel[0]
        ControlSend($Handle, "", "", "+{RIGHT}")
        $s = ControlCommand("[ACTIVE]", "", $EditWindow, "GetSelected", "")
        ControlSend($Handle, "", "", $CancelKey)
    Until $s = "" OR $s = @CRLF OR $s = @CR OR $s = @LF
    If $s <> "" Then
        If $a = $SelStart Then $RINL = True
        If $NL = "" Then $NL = $s
    Else
        If $NL = "" Then SetNL(IniRead($IniFile, "Editor", "NewlineChar", ""))
    EndIf
    Return $RINL
EndFunc

; $n ̋󔒂𓾂 ----------------------------------------------------
Func SetSpaces($n)
    $s = ""
    For $i = 1 To $n
        $s &= " "
    Next
    Return $s
EndFunc

; ^Cgo[t@C𓾂 -----------------------------------------
Func SetFileNameFromTitleBar()
    $s = IniRead($IniFile, "Editor", "TitleBar", "")
    $s = StringReplace($s, "/SPACE/", " ")
    $t = StringSplit($s, "|")
    $u = WinGetTitle("[active]")
    $i = StringInStr($u, $t[1])
    If $i = 0 Then $i = StringInStr($u, $t[2])
    If $i > 0 Then $FilePath = StringLeft($u, $i - 1)
EndFunc

; JgfBNg𓾂 -----------------------------------------------
Func SetWorkingDirectory()
    $s = StringReplace($FilePath, "/", "\")
    If StringMid($s, 2, 1) = ":" Then
        $n = StringInStr($s, "\", 0, -1)
        If $n > 0 Then $WDir = StringLeft($s, $n)
    EndIf
EndFunc

; \^C~Ox点 ---------------------------------------------
Func Delay()
    Sleep($Delay)
EndFunc

; ̃oCg߂ -------------------------------------------------
Func ByteLength($s)
    If $s = "" Then Return 0
    $k = StringLen($s)
    $i = 0
    $j = 0
    Do
        $i += 1
        If Asc(StringMid($s, $i, 1)) < 128 Then
            $j += 1
        Else
            $j += 2
        EndIf
    Until $i = $k
    Return $j
EndFunc

; Cfgݒ肷 -----------------------------------------------------
Func SetLeftIndent($n)
    Global $LeftSpace, $NLStart
    $t = ByteLength($Data) - $n
    If $t > $MaxLeftIndent Then
        $LeftSpace = ""
        $NLStart = True
    Else
        $LeftSpace = SetSpaces($t)
        $NLStart = False
    EndIf
EndFunc

; \ ---------------------------------------------------------
Func WriteString($s)
    While $s <> ""
        $t = StringRegExp($s, "(%(N|<|\(|>|(?:[LRUD]\d*)+%)(.*))$", 3)
        If $t <> $NoMatches Then
            If $t[0] <> $s Then Write(StringTrimRight($s, StringLen($t[0])))
            Move($t[1])
            If UBound($t) = 3 Then
                $s = $t[2]
            Else
                $s = ""
            EndIf
        Else
            Write($s)
            $s = ""
        EndIf
    WEnd
EndFunc

Func Write($s)
    $t = ""
    While $s <> ""
        $i = StringInStr($s, "%M", 1)
        $j = StringInStr($s, "%J", 1)
        $k = StringInStr($s, "%H", 1)
        $h = $i
        If $h = 0 OR ($j > 0 AND $j < $h) Then $h = $j
        If $h = 0 OR ($k > 0 AND $k < $h) Then $h = $k
        If $h = 0 Then
            $t &= $s
            ExitLoop
        EndIf
        $t &= StringLeft($s, $h - 1) & $NL
        $s = StringTrimLeft($s, $h + 1)
        If $h = $i Then
            $t &= $LeftSpace
        ElseIf $h = $j Then
            $t &= $LeftSpace & $AddSpace
        EndIf
    WEnd
    SimpleWrite($t)
EndFunc

Func SimpleWrite($s)
    If $AutoMode Then
        ControlCommand("[ACTIVE]", "", $EditWindow, "EditPaste", $s)
        Delay()
    Else
        ClipPut($s)
        Delay()
        ControlSend($Handle, "", "", $Paste)
        ClipPut("")
    EndIf
EndFunc

Func Move($s)
    If $s = "N" Then
        NextLine()
    ElseIf $s = "<" Then
        ControlSend($Handle, "", "", $LineTop)
    ElseIf $s = "(" Then
        ControlSend($Handle, "", "", $LineTop2)
    ElseIf $s = ">" Then
        ControlSend($Handle, "", "", $LineEnd)
    Else
        $s = StringTrimRight($s, 1)
        $s = StringRegExpReplace($s, "(\d+)", " \0")
        $s = StringReplace($s, "L", "}{LEFT")
        $s = StringReplace($s, "R", "}{RIGHT")
        $s = StringReplace($s, "U", "}{UP")
        $s = StringReplace($s, "D", "}{DOWN")
        $s = StringTrimLeft($s, 1) & "}"
        ControlSend($Handle, "", "", $s)
    EndIf
EndFunc

Func NextLine()
    If $RightIsNewtLine Then
        ControlSend($Handle, "", "", "{RIGHT}")
    Else
        SimpleWrite($NL)
    EndIf
EndFunc

; T -------------------------------------------------------------
Func Search($s, $t)
    $File = FileOpen($t, 0)
    $DicData = @CRLF & FileRead($File) & @CRLF
    FileClose($File)
    $x = StringInStr($DicData, @LF & $s & @TAB, 1)
    If $x > 0 Then
        $DicData = StringTrimLeft($DicData, $x)
        $Result = StringRegExp($DicData, "^.+\t+(.+)\r", 3)
        If $Result <> $NoMatches Then Return $Result[0]
    EndIf
    Return ""
EndFunc

;  -----------------------------------------------------------------
Func Replace($s)
    ControlSend($Handle, "", "", "{BS " & $BsLen & "}")
    WriteString($s)
EndFunc

Func SimpleReplace($s)
    ControlSend($Handle, "", "", "{BS " & $BsLen & "}")
    SimpleWrite($s)
EndFunc

; ⊮T -----------------------------------------------------------
Func SearchCsStart($R, $n, $t)
    Global $InputStr, $SearchCs
    $InputStr = $R[$n]
    Switch UBound($R)
        Case $n + 1
            $SearchCs = $InputStr & "%"
        Case $n + 2
            $SearchCs = $InputStr
        Case $n + 3
            If $R[$n + 1] = "" Then
                $SearchCs = $InputStr & "%\*"
            Else
                $SearchCs = $InputStr & "\*"
            EndIf
            $InputStr &= "*"
    EndSwitch
    If $UseAt = "No" Then
        $SearchCs = StringReplace($SearchCs, "-", "[a-zA-Z]+")
        $SearchCs = StringReplace($SearchCs, "%", "[a-zA-Z]*")
    Else
        $SearchCs = StringReplace($SearchCs, "-", "[a-zA-Z@]+")
        $SearchCs = StringReplace($SearchCs, "%", "[a-zA-Z@]*")
    EndIf
    Switch $t
        Case -2 To 0
            $SearchCs = "\n(" & $SearchCs & ")(\r|\t.*\r)"
        Case 1
            $SearchCs = "\n(" & $SearchCs & ")(\t*\r|\t+[^\t%].*\r|\t+%.+\r)"
        Case 2
            $SearchCs = "\n(" & $SearchCs & ")(\t+%arg1\r|\t+OPTION\r)"
        Case 3
            $SearchCs = "\n(" & $SearchCs & ")(\t+%\r)"
    EndSwitch
    SearchCs($t)
EndFunc

Func SearchCs($t)
    Global $CsList, $Items
    If $CsType = 1 Then
        If $t = -1 Then
            $DicData = GetData($UsedDic) & @CRLF
        Else
            $DicData = GetData($UserDic)
            If $UseAt = "AtOnly" Then
                $DicData &= GetData($AtDic) & @CRLF
            Else
                If $DicType < 3 Then
                    $DicData &= GetData($CsDic)
                    $DicData &= GetData($CsOtherDic)
                    $DicData &= GetData($TeXDic)
                    If $DicType = 2 Then $DicData &= GetData($CsAMSDic)
                Else
                    $DicData &= GetData($TeXDic)
                    $DicData &= GetData($CsDic)
                EndIf
                If $UseAt = "Yes" Then $DicData &= GetData($AtDic)
                $DicData &= @CRLF
            EndIf
        EndIf
    Else
        $DicData = GetData($EnvUserDic)
        $DicData &= GetData($EnvDic)
        If $DicType = 2 Then $DicData &= GetData($EnvAMSDic)
        $DicData &= GetData($EnvOtherDic) & @CRLF
    EndIf
    $CsList = StringRegExp($DicData, $SearchCs, 3)
    If $CsList <> $NoMatches Then
        $Save = "No"
        $Items = UBound($CsList) / 2  - 1
        If $t > 0 OR $CsType = 1 Then
            For $i = 0 To $Items
                If $CsList[$i * 2] = $InputStr Then
                    If $t > 0 OR StringRegExp($CsList[$i * 2 + 1], "(^\t*\r|\t+%\r)", 0) = 1 Then
                        For $j = $i * 2 To UBound($CsList) - 3
                            $CsList[$j] = $CsList[$j + 2]
                        Next
                        $Items -= 1
                    EndIf
                    ExitLoop
                EndIf
            Next
        EndIf
        If $Items > 0 Then
            ShowList($t)
        ElseIf $Items = 0 Then
            If $t = -1 Then
                ShowList($t)
            ElseIf $t <= 0 Then
                Completion(0)
            Else
                $CompleteCs = $CsList[0]
            EndIf
        ElseIf $t = -1 Then
            SearchCs(0)
        EndIf
    ElseIf $t = -1 Then
        SearchCs(0)
    ElseIf $t = 0 AND $Save = "Yes" AND StringLen($InputStr) <= $MaxCsLen Then
        If StringInStr($InputStr, "-") = 0 Then
            If $CsType = 1 Then
                If StringLen($InputStr) >= $MinCsLen Then
                    $YN = MsgBox(4, "o^", "\" & $InputStr & " ɓo^܂H", 0, $Handle)
                    If $YN = 6 Then SetData($UserDic, $InputStr) ; YES
                EndIf
            Else
                $YN = MsgBox(4, "̍쐬", $InputStr & " ƂĊ쐬܂H", 0, $Handle)
                If $YN = 6 Then ; YES
                    MakeEnv($InputStr)
                    If StringLen($InputStr) >= $MinCsLen Then
                        $YN = MsgBox(4, "o^", $InputStr & " ƂĎɓo^܂H", 0, $Handle)
                        If $YN = 6 Then SetData($EnvUserDic, $InputStr) ; YES
                    EndIf
                EndIf
            EndIf
        EndIf
    EndIf
EndFunc

Func GetData($F)
    $File = FileOpen($F, 0)
    $s = @CRLF & FileRead($File)
    FileClose($File)
    Return $s
EndFunc

Func MakeEnv($s)
    ControlSend($Handle, "", "", "{BS " & $BsLen & "}")
    WriteString("\begin{" & $s & "}%J%M\end{" & $s & "}%N%U2%%>")
EndFunc

Func SetData($F, $s)
    $File = FileOpen($F, 1)
    FileWriteLine($File, $s & @CRLF)
    FileClose($File)
    MsgBox(0, "o^", "o^܂D", 1)
EndFunc

; ⊮̃Xg\ -----------------------------------------------
Func ShowList($t)
    $ListViewOpt = $ListViewOption
    If $t <= 0 Then
        SetMenuPos(100, 155)
        If $t = -2 Then $ListViewOpt = $LVS_LIST
    Else
        GUISetState(@SW_DISABLE)
        If $t = 1 Then
            $MenuLeft = -1
            $MenuTop = -1
        EndIf
        HotKeySet($Shortcut)
    EndIf
    HotKeySet("{ENTER}", "GetItem")
    HotKeySet("{SPACE}", "MoveDown")
    HotKeySet("+{SPACE}", "MoveUp")
    $PopUpListWindow = GUICreate("", 100, 155, $MenuLeft, $MenuTop, $WS_POPUP, -1, $ParentWindowHandle)
    $ListView = GUICtrlCreateListView("", 0, 0, 100, 155, $ListViewOpt)
    For $i = 0 to $Items
        If $t <= 0 Then
            If $CsType < 0 Then
                GUICtrlCreateListViewItem($CsList[$i*2], $ListView)
            ElseIf $CsType = 1 Then
                GUICtrlCreateListViewItem("\" & $CsList[$i*2], $ListView)
            Else
                GUICtrlCreateListViewItem("\begin  " & $CsList[$i*2], $ListView)
            EndIf
        Else
            GUICtrlCreateListViewItem($CsList[$i*2], $ListView)
        EndIf
    Next
    If $t = -1 Then
        GUICtrlCreateListViewItem("all_______", $ListView)
        $Items += 1
    ElseIf $t = -2 AND $CsType >= -1 Then
        GUICtrlCreateListViewItem("edit_______", $ListView)
        $Items += 1
    EndIf
    GUISetState()
    MoveDown()
    $ShowChild = True
    $ListContinue = True
    $a = 0
    While $ListContinue
        $Msg = GUIGetMsg()
        Switch $Msg
            Case $ListView + 1 To $ListView + $Items + 1
                ExitLoop
            Case $GUI_EVENT_CLOSE
                $a = 1
                ExitLoop
        EndSwitch
    WEnd
    HotKeySet("{ENTER}")
    HotKeySet("{SPACE}")
    HotKeySet("+{SPACE}")
    If $a = 0 Then $n = GUICtrlRead($ListView) - $ListView - 1
    If $t > 0 Then GUISetState(@SW_ENABLE, $SelectionModeWindow)
    GUIDelete($PopUpListWindow)
    Delay()
    If $a = 0 Then
        If $CsType < -1 OR ($CsType = -1 AND $n < $Items) Then
            ControlSend($Handle, "", "", "{BS}")
            $s = $CsList[$n*2+1]
            If $CsType = -1 Then
                WriteString($s)
            Else
                SimpleWrite($s)
                If $CsType = -3 AND StringRight($s, 1) = "}" Then
                    ControlSend($Handle, "", "", "{LEFT}")
                    $CsType = 1
                    AddToUsedDic(StringMid($s,2,StringLen($s)-3), @TAB & @TAB & "%arg1")
                Else
                    $CsType = 1
                    AddToUsedDic(StringTrimLeft($s,1), "")
                EndIf
            EndIf
        ElseIf $t = -2 AND $n = $Items Then
            Run($Editor & " " & $CurrentDic)
        ElseIf $t = -1 AND $n = $Items Then
            SearchCs(0)
        ElseIf $t <= 0 Then
            If $t = -2 Then
                If $CsType = 2 Then
                    $BsLen = 2
                Else
                    $BsLen = 0
                EndIf
                SetLeftIndent($CsType)
            EndIf
            Completion($n)
        Else
            $CompleteCs = $CsList[$n*2]
        EndIf
    EndIf
EndFunc

Func GetItem()
    $ListContinue = False
EndFunc

Func MoveUp()
    Send("{UP}")
EndFunc

Func MoveDown()
    Send("{DOWN}")
EndFunc

; IvVj[ -------------------------------------------------------
Func ShowOptionMenu($s)
    $t = Search($s, $CsSubDic)
    If $t = "" Then
        WriteString("{}%L%")
        Exit
    EndIf
    $u = StringSplit($t, "|")
    If $u[0] = 1 AND StringRight($u[1], 1) <> "%" Then
        SimpleWrite("{" & $u[1] & "}")
        Exit
    EndIf
    HotKeySet("{ENTER}", "GetItem")
    HotKeySet("{SPACE}", "MoveDown")
    HotKeySet("+{SPACE}", "MoveUp")
    SetMenuPos(100, 155)
    $PopUpListWindow = GUICreate("", 100, 155, $MenuLeft, $MenuTop, $WS_POPUP, -1, $Handle)
    $ListView = GUICtrlCreateListView("", 0, 0, 100, 155, $ListViewOption)
    for $i = 1 to $u[0]
        If StringRight($u[$i], 1) = "%" Then
            GUICtrlCreateListViewItem(StringTrimRight($u[$i], 1), $ListView)
        Else
            GUICtrlCreateListViewItem($u[$i], $ListView)
        EndIf
    Next
    GUISetState()
    MoveDown()
    $ListContinue = True
    $a = 0
    While $ListContinue
        $Msg = GUIGetMsg()
        Switch $Msg
            Case $ListView + 1 To $ListView + $u[0]
                ExitLoop
            Case $GUI_EVENT_CLOSE
                $a = 1
                ExitLoop
        EndSwitch
    WEnd
    WinActivate($Handle)
    If $a = 0 Then
        $x = $u[GUICtrlRead($ListView) - $ListView]
        GUIDelete($PopUpListWindow)
        If StringRight($x, 1) = "%" Then
            $y = Search($x, $CsSubDic)
            $x = StringTrimRight($x, 1)
            If $y <> "" Then
                $z = StringSplit($y, "|")
                If $z[0] = 1 Then
                    $w = $z[1]
                    If $w = "---" Then
                        SimpleWrite("[]{" & $x & "}")
                        WriteString("%L" & StringLen($x) + 3 & "%")
                    Else
                        SimpleWrite("[" & $z[1] & "]{" & $x & "}")
                    EndIf
                    Exit
                Else
                    $PopUpListWindow = GUICreate("", 100, 155, $MenuLeft, $MenuTop, $WS_POPUP, -1, $Handle)
                    $ListView = GUICtrlCreateListView("", 0, 0, 100, 155, $ListViewOption)
                    for $i = 1 to $z[0]
                        GUICtrlCreateListViewItem($z[$i], $ListView)
                    Next
                    GUISetState()
                    MoveDown()
                    $ListContinue = True
                    $a = 0
                    While $ListContinue
                        $Msg = GUIGetMsg()
                        Switch $Msg
                            Case $ListView + 1 To $ListView + $z[0]
                                ExitLoop
                            Case $GUI_EVENT_CLOSE
                                $a = 1
                                ExitLoop
                        EndSwitch
                    WEnd
                    If $a = 0 Then $w = $z[GUICtrlRead($ListView) - $ListView]
                    GUIDelete($PopUpListWindow)
                    If $a = 0 Then
                        If $w = "---" Then
                            SimpleWrite("[]{" & $x & "}")
                            WriteString("%L" & StringLen($x) + 3 & "%")
                            Exit
                        EndIf
                        SimpleWrite("[" & $w & "]")
                    EndIf
                EndIf
            EndIf
        EndIf
        WriteString("{" & $x & "}")
    Else
        GUIDelete($PopUpListWindow)
        WriteString("{}%L%")
    EndIf
    Exit
EndFunc

; j[̈ʒu߂ ---------------------------------------------------
Func SetMenuPos($x, $y)
    Global $MenuLeft, $MenuTop
    $CaretPos = WinGetCaretPos()
    $MenuLeft = $CaretPos[0] + 4
    $MenuRight = $MenuLeft + $x
    $MenuTop = $CaretPos[1] + 31 + $AddMenuTop
    $MenuBottom = $MenuTop + $y
    If $MenuLeft < 50 Then
        $MenuLeft = 50
    ElseIf $MenuRight > @DesktopWidth - 50 Then
        $MenuLeft = @DesktopWidth - $x - 50
    EndIf
    If $MenuTop < 100 Then
        $MenuTop = 100
    ElseIf $MenuBottom > @DesktopHeight - 100 Then
        $MenuTop = @DesktopHeight - $y -100
    EndIf
EndFunc

; ⊮ ---------------------------------------------------------------------
Func Completion($i)
    $CompleteCs = $CsList[$i*2]
    $AfterCs = StringTrimRight($CsList[$i*2+1], 1)
    If $MaxCs > 0 Then AddToUsedDic($CompleteCs, $AfterCS)
    If $BsLen > 0 Then ControlSend($Handle, "", "", "{BS " & $BsLen & "}")
    If $CsType = 1 Then
        SimpleWrite($CompleteCs)
        Switch $CompleteCs
            Case "documentclass"
                Documentclass()
            Case "input", "include", "includeonly", "bibliography", "includegraphics", "blackandwhite", "colorslides"
                GetFileName($CompleteCs)
            Case "newread", "newwrite"
                FileIO($CompleteCs)
            Case "matrix", "pmatrix"
                Array("\" & $CompleteCs, 0)
            Case "ref", "pageref", "eqref"
                LabelList(0)
        EndSwitch
    ElseIf StringRegExp($AfterCs, "^\t+%$", 0) = 1 Then
        SimpleWrite("\begin{" & $CompleteCs & "}  \end{" & $CompleteCs & "}")
        ControlSend($Handle, "", "", "{LEFT " & StringLen($CompleteCs) + 7 & "}")
        Exit
    ElseIf $CompleteCs = "document" Then
        If $NLStart Then SimpleWrite($NL)
        SimpleWrite("\begin{document}" & $NL & $NL & "\end{document}")
        NextLine()
        ControlSend($Handle, "", "", "{UP 2}")
        Exit
    Else
        If $NLStart Then SimpleWrite($NL)
        SimpleWrite("\begin{" & $CompleteCs & "}" & $NL & $LeftSpace & $AddSpace & $NL & $LeftSpace & "\end{" & $CompleteCs & "}")
        NextLine()
        ControlSend($Handle, "", "", "{UP 2}")
        ControlSend($Handle, "", "", $LineEnd)
        If $CompleteCs = "tabular" OR $CompleteCs = "tabular*" OR $CompleteCs = "tabularx" Then
            Tabular($CompleteCs, 0)
        ElseIf $CompleteCs = "array" Then
            Array($CompleteCs, 1)
        ElseIf $CompleteCs = "matrix" OR StringTrimLeft($CompleteCs, 1) = "matrix" Then
            Array($CompleteCs, 0)
        EndIf
    EndIf
    If $AfterCs = "" Then Exit
    $AfterCs = StringRegExpReplace($AfterCs, "^\t+", "")
    If $AfterCs = "" OR $AfterCs = "%" Then Exit
    If $AfterCs = "OPTION" Then ShowOptionMenu($CompleteCs)
    $s = Search($AfterCs, $DefFile)
    If $s <> "" Then
        WriteString($s)
    Else
        WriteString($AfterCs)
    EndIf
EndFunc

; t@Cf[^ǂݍ -----------------------------------------
Func GetAllData($s, $t, $u)
    If $t < 0 Then
        $t = -$t
        $PicupRecent = True
    Else
        $PicupRecent = False
    EndIf
    Global $CsList[$t*2], $Items, $CurrentDic
    $File = FileOpen($s, 0)
    $Items = 0
    While $Items < $t
        $Line = FileReadLine($File)
        If @error = -1 Then ExitLoop
        If $Line <> "" AND StringLeft($Line, 2) <> "% " Then
            $x = StringInStr($Line, @TAB)
            If $x > 0 Then
                $a = StringLeft($Line, $x - 1)
                $b = StringTrimLeft($Line, $x - 1)
                If $u < 0 Then
                    While StringLeft($b, 1) = @TAB
                        $b = StringTrimLeft($b, 1)
                    WEnd
                    $c = 5 - StringLen($a)
                    If $c <= 0 Then $c = 1
                    $a &= SetSpaces($c) & $b
                    $a = StringReplace($a, "|", "l")
                    ; Vertical bar ܂ޕ̓j[ɕ\Ȃ
                    ; 悤Ȃ̂ŁAGɒuĕ\
                Else
                    $b &= @CR
                EndIf
                $CsList[$Items*2] = $a
                $CsList[$Items*2+1] = $b
            Else
                $CsList[$Items*2] = $Line
                $CsList[$Items*2+1] = ""
            EndIf
            $Items += 1
        EndIf
    Wend
    FileClose($File)
    If $Items = 0 Then Exit
    $Items -= 1
    $CsType = $u
    $CurrentDic = $s
    If $PicupRecent Then
        If $Items = $t - 1 Then
            If $u = 1 Then
                $BsLen = 1
            Else
                $BsLen = 3
            EndIf
            SetLeftIndent($CsType + 1)
            Completion($Items)
        EndIf
    Else
        ShowList(-2)
    EndIf
EndFunc

; gp cs L^ ---------------------------------------------------
Func AddToUsedDic($s, $t)
    If $CsType <> 1 Then
        $UsedDic = $UsedEnvDic
        $MaxCs = $MaxUsedEnv
    EndIf
    $File = FileOpen($UsedDic, 0)
    $DicData = @CRLF & FileRead($File)
    FileClose($File)
    $u = StringReplace($s, "*", "\*")
    $DicData = $s & $t & StringRegExpReplace($DicData, "\n" & $u & "(\r|\t.*\r)", "")
    $i = StringInStr($DicData, @CRLF, 0, $MaxCs)
    If $i > 0 Then $DicData = StringLeft($DicData, $i + 1)
    $File = FileOpen($UsedDic, 2)
    FileWrite($File, $DicData)
    FileClose($File)
EndFunc

; j[֘A -------------------------------------------------------------
Func Check($x)
    GUICtrlSetState($x, $GUI_CHECKED)
EndFunc

Func Focus($x)
    GUICtrlSetState($x, $GUI_FOCUS)
EndFunc

Func Show($x, $y)
    For $i = 0 To $y
        GUICtrlSetState($x + $i, $GUI_ENABLE)
    Next
EndFunc

Func Hide($x, $y)
    For $i = 0 To $y
        GUICtrlSetState($x + $i, $GUI_DISABLE)
    Next
EndFunc

; ݒ胁j[\ ---------------------------------------------------
Func Setting()
    $SettingWindow = GUICreate("HappyInput ݒ胁j[", 310, 585, -1, -1, $WS_CAPTION + $WS_SYSMENU, -1, $Handle)
    GuiCtrlCreateGroup("", 10, 15, 140, 150)
    $LaTeX     = GuiCtrlCreateRadio   ("LaTeX",              25,  35,  60)
    $LaTeXAMS  = GuiCtrlCreateRadio   ("LaTeX + AMSMath",    25,  55, 120)
    $plain     = GuiCtrlCreateRadio   ("plain",              25,  75,  50)
    $At        = GUICtrlCreateCheckbox("@ ܂߂",         25,  95,  90)
    $RenewDic  = GUICtrlCreateCheckbox("o^",       25, 115,  90)
    $UseUsedCs = GUICtrlCreateCheckbox("gp cs g", 25, 135, 120)
    GuiCtrlCreateGroup("Ɏc", 160, 15, 140, 150)
    GuiCtrlCreateLabel("gp cs", 175, 40)
    $UsedCs = GUICtrlCreateInput($MaxCs, 245, 35, 40)
    GuiCtrlCreateLabel("sI", 175, 70)
    GuiCtrlCreateLabel("section^", 185, 94)
    $SectionType = GUICtrlCreateInput($MaxCsA, 245, 89, 40)
    $UpDownSection = GUICtrlCreateUpdown($SectionType, $UDS_SETBUDDYINT)
    GUICtrlSetLimit($UpDownSection, $MaxMaxCsA, 0)
    GuiCtrlCreateLabel("large^", 185, 117)
    $LargeType = GUICtrlCreateInput($MaxCsB, 245, 112, 40)
    $UpDownLarge = GUICtrlCreateUpdown($LargeType, $UDS_SETBUDDYINT)
    GUICtrlSetLimit($UpDownLarge, $MaxMaxCsB, 0)
    GuiCtrlCreateLabel("", 185, 140)
    $EnvTypeMenu = GUICtrlCreateInput($MaxEnv, 245, 135, 40)
    $UpDownEnv = GUICtrlCreateUpdown($EnvTypeMenu, $UDS_SETBUDDYINT)
    GUICtrlSetLimit($UpDownEnv, $MaxMaxEnv, 0)
    $UseCurrentCs = GUICtrlCreateButton(" ݕɂ cs  gp cs Ƃēo^", 10, 178, 290, 24)
    GuiCtrlCreateGroup("Rg", 10, 215, 140, 70)
    $Comment = GuiCtrlCreateRadio ("% ̂",       25, 235, 50)
               GuiCtrlCreateRadio ("% + Xy[X", 25, 255, 80)
    GuiCtrlCreateGroup("|bvAbv̍", 160, 215, 140, 70)
    $NotSorted = GuiCtrlCreateRadio ("\[gȂ", 175, 235, 80)
                 GuiCtrlCreateRadio ("\[g",   175, 255, 80)
    GuiCtrlCreateLabel("̒̃Cfg@", 20, 305)
    $EnvIndentAmount = GUICtrlCreateInput($EnvIndent, 140, 300, 40)
    $UpDownEnvIndent = GUICtrlCreateUpdown($EnvIndentAmount, $UDS_SETBUDDYINT)
    GUICtrlSetLimit($UpDownEnvIndent, $MaxEnvIndent, 0)
    GuiCtrlCreateGroup("ftHg̕NX", 10, 335, 150, 50)
    $jarticle  = GuiCtrlCreateRadio ("jarticle",  25, 355, 60)
                 GuiCtrlCreateRadio ("jsarticle", 90, 355, 60)
    GuiCtrlCreateGroup("ev[g", 10, 395, 290, 130)
    $TempNo = GuiCtrlCreateRadio ("}Ȃ",  25, 415, 70)
    $Temp1  = GuiCtrlCreateRadio ("} 1",      25, 435, 60)
    $Temp2  = GuiCtrlCreateRadio ("} 2",      93, 435, 60)
    $Temp3  = GuiCtrlCreateRadio ("} 3",     161, 435, 60)
    $Temp4  = GuiCtrlCreateRadio ("} 4",     229, 435, 60)
    $TCT    = GuiCtrlCreateRadio ("\ itable -- center -- tabularj", 25, 455, 180)
    $FCP    = GuiCtrlCreateRadio ("} ifigure -- center -- picturej", 25, 475, 180)
    $FCG    = GuiCtrlCreateRadio ("} ifigure -- center -- \includegraphicsj", 25, 495, 240)
    $UsedDicEdit = GUICtrlCreateButton("gp cs ̕ҏW", 190, 298, 110, 24)
    $Edit = GUICtrlCreateButton("̕ҏW", 225, 329, 75, 24)
    $SaveLabel = GUICtrlCreateButton("x̓o^", 165, 360, 85, 24)
    $About = GUICtrlCreateButton("About", 255, 360, 45, 24)
    $OK = GUICtrlCreateButton("OK", 120, 545, 65, 24)
    Check($LaTeX + $DicType - 1)
    If $UseAt = "Yes" Then Check($At)
    If $Save  = "Yes" Then Check($RenewDic)
    If $ReUse = "Yes" Then Check($UseUsedCs)
    Check($Comment + $CommentType - 1)
    Check($NotSorted + $Sort - 1)
    Check($jarticle + $ClassName - 1)
    $Template = 0
    Check($TempNo)
    If $WDir = "" Then
        Hide($UseCurrentCs, 1)
        Hide($SaveLabel, 0)
    EndIf
    If $DicType = 3 Then
        Hide($EnvTypeMenu - 1, 2)
        GuiCtrlCreateLabel("ubN̒̃Cfg", 20, 305)
        Hide($jarticle, 1)
        Hide($SaveLabel, 0)
        Hide($TCT, 2)
    EndIf
    $PicUpCs = False
    $DicEdit = 0
    $SaveLabelMode = False
    Focus($OK)
    GUISetState()
    $ParentWindowHandle = ControlGetHandle("[ACTIVE]", "", "")
    $ShowChild = False
    While True
        $Msg = GUIGetMsg()
        Switch $Msg
            Case $LaTeX, $LaTeXAMS
                If $DicType = 3 Then
                    Show($EnvTypeMenu - 1, 2)
                    GuiCtrlCreateLabel("̒̃Cfg@", 20, 305)
                    Show($jarticle, 1)
                    If $WDir <> "" Then Show($SaveLabel, 0)
                    Show($TCT, 2)
                EndIf
                $DicType = $Msg - $LaTeX + 1
            Case $plain
                If $DicType < 3 Then
                    Hide($EnvTypeMenu - 1, 2)
                    GuiCtrlCreateLabel("ubN̒̃Cfg", 20, 305)
                    Hide($jarticle, 1)
                    Hide($SaveLabel, 0)
                    If $Template > 4 Then
                        $Template = 0
                        Check($TempNo)
                    EndIf
                    Hide($TCT, 2)
                EndIf
                $DicType = 3
            Case $TempNo, $Temp1, $Temp2, $Temp3, $Temp4, $TCT, $FCP, $FCG
                $Template = $Msg - $TempNo
            Case $UseCurrentCs
                If GUICtrlRead($UseUsedCs) = $GUI_CHECKED AND GUICtrlRead($UsedCs) > 0 Then
                    $PicUpCs = True
                    ExitLoop
                EndIf
            Case $UsedDicEdit
                $DicEdit = 1
                ExitLoop
            Case $Edit
                $DicEdit = 2
                ExitLoop
            Case $SaveLabel
                $SaveLabelMode = True
                ExitLoop
            Case $About
                ShowAbout()
                $ShowChild = True
            Case $GUI_EVENT_CLOSE
                If $ShowChild Then
                    GUIDelete($SettingWindow)
                    WinActivate($Handle)
                EndIf
                Exit
            Case $OK
                $ExitLoop = CheckRange($UsedCs, $MaxMaxCs, 0, $MaxCs, 0)
                $ExitLoop = CheckRange($SectionType, $MaxMaxCsA, 0, $MaxCsA, 0) AND $ExitLoop
                $ExitLoop = CheckRange($LargeType, $MaxMaxCsB, 0, $MaxCsB, 0) AND $ExitLoop
                $ExitLoop = CheckRange($EnvTypeMenu, $MaxMaxEnv, 0, $MaxEnv, 1) AND $ExitLoop
                $ExitLoop = CheckRange($EnvIndentAmount, $MaxEnvIndent, 0, $EnvIndent, 0) AND $ExitLoop
                If $ExitLoop Then ExitLoop
        EndSwitch
    WEnd
    IniWrite($IniFile, "Dictionary", "Type", $DicType)
    WriteToIni($At, "Dictionary", "UseAt", "Yes", "No")
    $UseAt = IniRead($IniFile, "Dictionary", "UseAt", "")
    WriteToIni($RenewDic, "Dictionary", "Save", "Yes", "No")
    WriteToIni($Comment, "Document", "CommentType", "1", "2")
    WriteToIni($NotSorted, "Script", "Sort", "1", "2")
    $EnvIndent = GUICtrlRead($EnvIndentAmount)
    IniWrite($IniFile, "Document", "Indent", $EnvIndent)
    $AddSpace = SetSpaces($EnvIndent)
    WriteToIni($jarticle, "Document", "ClassName", "1", "2")
    $n = GUICtrlRead($UsedCs)
    IniWrite($IniFile, "History", "Cs", $n)
    If $n = 0 Then GUICtrlSetState($UseUsedCs, $GUI_UNCHECKED)
    WriteToIni($UseUsedCs, "Dictionary", "ReUse", "Yes", "No")
    CheckHistory("CsA", GUICtrlRead($SectionType))
    CheckHistory("CsB", GUICtrlRead($LargeType))
    CheckHistory("Env", GUICtrlRead($EnvTypeMenu))
    GUIDelete($SettingWindow)
    If $ShowChild Then WinActivate($Handle)
    If $PicUpCs Then
        MakeCsList()
        Exit
    EndIf
    If $DicEdit = 1 Then
        Run($Editor & " " & $UsedDic)
        Exit
    EndIf
    If $DicEdit = 2 Then
        If $DicType < 3 Then
            $Filter = "User files (*.usr;*.dat)|All(*.*)"
        Else
            $Filter = "User files (*.pusr;*.dat)|All(*.*)"
        EndIf
        $t = FileOpenDialog("t@CI", $DicDir, $Filter, 1, "", $Handle)
        If $t <> "" Then Run($Editor & " " & $t)
        Exit
    EndIf
    If $SaveLabelMode Then
        MakeLabelList(0)
        Exit
    EndIf
    Switch $Template
        Case 1 To 4
            $TemplateBody = ""
            $File = FileOpen($TemplateFile, 0)
            $DicData = FileRead($File)
            FileClose($File)
            $SearchStr = "-----(Template " & $Template & ")-----------------------------------------------------------" & @CRLF
            $x = StringInStr($DicData, $SearchStr)
            If $x > 0 Then
                $DicData = StringTrimLeft($DicData, $x + StringLen($SearchStr) - 1)
                If $Template < 4 Then
                    $s = $Template + 1
                Else
                    $s = "x"
                EndIf
                $SearchStr = "-----(Template " & $s & ")-----------------------------------------------------------"
                $x = StringInStr($DicData, $SearchStr)
                If $x > 0 Then
                    $TemplateBody = StringLeft($DicData, $x - 1)
                    If $NL <> @CRLF Then $TemplateBody = StringReplace($TemplateBody, @CRLF, $NL)
                EndIf
            EndIf
            If $TemplateBody <> "" Then SimpleWrite($TemplateBody)
        Case 5
            SimpleWrite("\begin{table}[]" & $NL & $AddSpace & "\begin{center}" & $NL & $AddSpace & $AddSpace & "\begin{tabular}" & $NL & $AddSpace & $NL & $AddSpace & $AddSpace & "\end{tabular}" & $NL & $AddSpace & $AddSpace & "\caption{}" & $NL & $AddSpace & "\end{center}" & $NL & "\end{table}")
            WriteString("%N%U5%")
            Tabular("tabular", 1)
        Case 6
            SimpleWrite("\begin{figure}[]" & $NL & $AddSpace & "\begin{center}" & $NL & $AddSpace & $AddSpace & "\begin{picture}(100,100)" & $NL & $AddSpace & $AddSpace & $AddSpace & "\put(0,0){}" & $NL & $AddSpace & $AddSpace & "\end{picture}" & $NL & $AddSpace & $AddSpace & "\caption{}" & $NL & $AddSpace & "\end{center}" & $NL & "\end{figure}");
            WriteString("%N%U7L2%")
        Case 7
            SimpleWrite("\begin{figure}[]" & $NL & $AddSpace & "\begin{center}" & $NL & $AddSpace & $AddSpace & "\includegraphics" & $NL & $AddSpace & $AddSpace & "\caption{}" & $NL & $AddSpace & "\end{center}" & $NL & "\end{figure}")
            WriteString("%N%U3L%")
            GetFileName("includegraphics")
    EndSwitch
    Exit
EndFunc

Func ShowAbout()
    $Website = "http://www.u-gakugei.ac.jp/~takizawa/Happy/"
    $AboutWindow = GUICreate("About", 225, 130, -1, -1, BitOr($WS_CAPTION, $WS_SYSMENU), -1, $ParentWindowHandle)
    GuiCtrlCreateLabel("TeX ͎xXNvg", 15, 10)
    GuiCtrlCreateLabel("HappyInput  Ver " & $Version & "  " & $Date, 15, 35)
    GuiCtrlCreateLabel("by  ", 15, 60)
    $URL = GUICtrlCreateButton("Web TCg", 110, 57, 100, 21)
    $OK = GUICtrlCreateButton("OK", 67, 100, 91, 21)
    Focus($OK)
    GUISetState()
    While True
        $Msg = GUIGetMsg()
        Switch $Msg
            Case $URL
                ShellExecute($Website, "", "", "open")
                Exit
            Case $GUI_EVENT_CLOSE, $OK
                ExitLoop
        EndSwitch
    WEnd
    GUIDelete($AboutWindow)
EndFunc

Func WriteToIni($s, $a, $b, $x, $y)
    If GUICtrlRead($s) = $GUI_CHECKED Then
        IniWrite($IniFile, $a, $b, $x)
    Else
        IniWrite($IniFile, $a, $b, $y)
    EndIf
EndFunc

Func CheckRange($s, $m, $n, $d, $a)
    If $a = 1 Then
        If GUICtrlGetState($s) = $GUI_SHOW + $GUI_ENABLE Then $a = 0
    EndIf
    If GUICtrlRead($s) = "" Then
        GUICtrlSetData($s, $d)
        If $a = 0 Then Return False
    Else
        If GUICtrlRead($s) > $m Then
            GUICtrlSetData($s, $m)
            If $a = 0 Then Return False
        EndIf
        If GUICtrlRead($s) < $n Then
            GUICtrlSetData($s, $n)
            If $a = 0 Then Return False
        EndIf
    EndIf
    Return True
EndFunc

Func CheckHistory($s, $n)
    IniWrite($IniFile, "History", $s, $n)
    If $n = 0 Then
        IniWrite($HisFile, $s, "Recent", "")
    Else
        $His = IniRead($HisFile, $s, "Recent", "")
        $i = StringInStr($His & "|", "|", 0, $n)
        If $i > 0 Then IniWrite($HisFile, $s, "Recent", StringLeft($His, $i - 1))
    EndIf
EndFunc

Func MakeCsList()
    $ConfirmWindow = GUICreate("mF", 220,160, -1, -1, $WS_CAPTION + $WS_SYSMENU, -1, $Handle)
    GuiCtrlCreateLabel("̃t@CēxǂݍŎs܂D", 15, 15)
    $DoSave = GUICtrlCreateButton("㏑ۑĂs", 20, 45, 180)
    $NoSave = GUICtrlCreateButton("̂܂܎s", 20, 80, 180)
    $Cancel = GUICtrlCreateButton("~", 20, 115, 180)
    Focus($DoSave)
    GUISetState()
    While True
        $Msg = GUIGetMsg()
        Switch $Msg
            Case $DoSave
                ControlSend($Handle, "", "", $SaveKey)
                Sleep(1000)
                ExitLoop
            Case $NoSave
                ExitLoop
            Case $Cancel, $GUI_EVENT_CLOSE
                Exit
        EndSwitch
    WEnd
    $File = FileOpen($FilePath, 0)
    If $File = -1 Then
        MsgBox(4096, "G[", "t@Cǂݍ߂܂D", 1)
        Exit
    EndIf
    $CurrentTextData = FileRead($File)
    FileClose($File)
    If $DicType < 3 Then
        Dim $BaseFiles[6] = [$UserDic, $CsDic, $CsOtherDic, $TeXDic, "", ""]
        $FileNum = 3
        If $DicType = 2 Then
            $FileNum += 1
            $BaseFiles[$FileNum] = $CsAMSDic
        EndIf
        If $UseAt = "Yes" Then
            $FileNum += 1
            $BaseFiles[$FileNum] = $AtDic
        EndIf
    Else
        Dim $BaseFiles[4] = [$UserDic, $TeXDic, $CsDic, ""]
        If $UseAt = "Yes" Then
            $FileNum = 3
            $BaseFiles[$FileNum] = $AtDic
        Else
            $FileNum = 2
        EndIf
    EndIf
    $CurrentCs = StringRegExp($CurrentTextData, "\\([a-zA-Z@]{" & $MinCsLen & ",})", 3)
    If $CurrentCs <> $NoMatches Then
        $File = FileOpen($UsedDic, 0)
        $UsedDataOrig = FileRead($File)
        FileClose($File)
        $UsedData = @CRLF & $UsedDataOrig & @CRLF
        $Num = UBound($CurrentCs) - 1
        $k = -1
        For $i = 0 To $Num
            $Current = $CurrentCs[$i]
            If $Current = "documentclass" OR $Current = "begin" OR $Current = "end" Then ContinueLoop
            If $UseAt = "Yes" OR StringInStr($Current, "@") = 0 Then
                $NewCs = True
                For $j = 0 To $k
                    If $CurrentCs[$j] = $Current Then
                        $NewCs = False
                        ExitLoop
                    EndIf
                Next
                If $NewCs AND StringRegExp($UsedData, "\n" & $Current & "(\r|\t.*\r)", 0) = 0 Then
                    $k += 1
                    $CurrentCs[$k] = $Current
                EndIf
            EndIf
        Next
        If $k >= 0 Then
            $DicData = ""
            For $i = 0 To $FileNum
                $File = FileOpen($BaseFiles[$i], 0)
                $DicData &= @CRLF & FileRead($File)
                FileClose($File)
            Next
            $DicData &= @CRLF
            $NewData = ""
            For $i = $k To 0 Step -1
                $Current = $CurrentCs[$i]
                $Result = StringRegExp($DicData, "\n(" & $Current & "(\r|\t.*\r))", 3)
                If $Result <> $NoMatches Then $Current = StringTrimRight($Result[0], 1)
                $NewData &= $Current & @CRLF
            Next
            $Lines = StringRegExp($NewData, "\r\n", 3)
            $MaxCs = IniRead($IniFile, "History", "Cs", "")
            IniWrite($IniFile, "History", "Cs", $MaxCs + UBound($Lines))
            $NewData &= $UsedDataOrig
            $File = FileOpen($UsedDic, 2)
            FileWrite($File, $NewData)
            FileClose($File)
            MsgBox(0, "o^", "o^܂D", 1)
        Else
            MsgBox(0, "o^ς", "ׂēo^ς݂łD", 1)
        EndIf
    EndIf
EndFunc

; xXg̍쐬EXV@----------------------------------------------
Func MakeLabelList($a)
    Dim $OrigLabels[$MaxLabels]
    $MakeLabelListWindow = GUICreate("xXg̍쐬EXV", 250, 210, -1, -1, $WS_CAPTION + $WS_SYSMENU, -1, $Handle)
    GuiCtrlCreateGroup("xT[`t@C", 10, 15, 230, 70)
    $This = GuiCtrlCreateRadio("̃t@Ci㏑ۑĎsj", 25, 35, 210)
            GuiCtrlCreateRadio("t@Cw肷ij", 25, 55, 180)
    GuiCtrlCreateGroup("쐬@", 10, 100, 230, 50)
    $Append = GuiCtrlCreateRadio("o^̂ݒǉ", 25, 120, 110)
              GuiCtrlCreateRadio("VKɍ쐬",  150, 120, 80)
    $OK  = GUICtrlCreateButton("OK", 92, 170, 66, 24)
    $SearchFileType = 0
    $MakeType = 1 ; 1:ǉ 2:u
    Check($This)
    Check($Append)
    Focus($OK)
    GUISetState()
    While True
        $Msg = GUIGetMsg()
        Switch $Msg
            Case $This, $This + 1
                $SearchFileType = $Msg - $This
            Case $Append, $Append + 1
                $MakeType = $Msg - $Append + 1
            Case $GUI_EVENT_CLOSE
                Exit
            Case $OK
                ExitLoop
        EndSwitch
    WEnd
    GUIDelete($MakeLabelListWindow)
    If $SearchFileType = 0 Then
        Sleep(500)
        ControlSend($Handle, "", "", $SaveKey) ; ㏑ۑ
        Sleep(1000)
        Dim $SearchFiles[2] = [1, $FilePath]
        $n = 1
    Else
        $t = FileOpenDialog("t@C̎w", $WDir, "TeX files (*.tex)|All(*.*)", 5, "", $Handle)
        If $t = "" Then Exit
        $SearchFiles = StringSplit($t, "|")
        $n = $SearchFiles[0]
        If $n > 1 Then
            $n -= 1
            $s = $SearchFiles[1]
            For $i = 1 To $n
                $SearchFiles[$i] = $s & "\" & $SearchFiles[$i+1]
            Next
        EndIf
        $ConfirmWindow = GUICreate("mF", 240, 200, -1, -1, $WS_CAPTION + $WS_SYSMENU, -1, $Handle)
        GuiCtrlCreateLabel("ȉ̃t@C烉xT[`܂D", 15, 15)
        $s = $SearchFiles[1]
        For $i = 2 To $n
            $s &= @CRLF & $SearchFiles[$i]
        Next
        GUICtrlCreateEdit($s, 15, 40, 210, 100, $WS_VSCROLL + $WS_HSCROLL)
        $OK  = GUICtrlCreateButton("OK", 85, 160, 70, 24)
        Focus($OK)
        GUISetState()
        While True
            $Msg = GUIGetMsg()
            Switch $Msg
                Case $GUI_EVENT_CLOSE
                    Exit
                Case $OK
                    ExitLoop
            EndSwitch
        WEnd
        GUIDelete($ConfirmWindow)
    EndIf
    If $MakeType = 1 Then
        $LabelFile = FileOpen($LabelData, 0)
        $Text = FileRead($LabelFile)
        FileClose($LabelFile)
        $Labels = StringSplit($Text, @CRLF, 3)
        $Items = UBound($Labels) - 2
        For $i = 0 To $Items
            $OrigLabels[$i] = $Labels[$i]
        Next
    Else
        $Items = -1
    EndIf
    $LabelFile = FileOpen($LabelData, $MakeType)
    $ExistsLabel = False
    For $i = 1 To $n
        $File = FileOpen($SearchFiles[$i], 0)
        $Text = FileRead($File)
        FileClose($File)
        $Labels = StringRegExp($Text, "\\label\{([^\{\}]+)\}", 3)
        If $Labels <> $NoMatches Then
            For $j = 0 To UBound($Labels) - 1
                $s = $Labels[$j]
                For $k = 0 To $Items
                    If $OrigLabels[$k] = $s Then ContinueLoop 2
                Next
                $ExistsLabel = True
                $Items += 1
                $OrigLabels[$Items] = $s
                FileWriteLine($LabelFile, $s)
            Next
        EndIf
    Next
    FileClose($LabelFile)
    If $ExistsLabel Then
        If $a = 0 Then
            If $MakeType = 1 Then
                $s "XV"
            Else
                $s = "쐬"
            EndIf
            MsgBox(0, "", "xXg" & $s & "܂D", 1)
        EndIf
    Else
        MsgBox(0, "xȂ", "Vx͂܂D", 1)
    EndIf
EndFunc

Func AddLabel($s)
    $File = FileOpen($LabelData, 0)
    $t = FileRead($File)
    FileClose($File)
    $Labels = StringSplit($t, @CRLF, 3)
    $Items = UBound($Labels) - 2
    For $i = 0 To $Items
        If $Labels[$i] = $s Then
            MsgBox(0, "o^ς", "x  """ & $s & """  ͂łɓo^Ă܂D", 1)
            Exit
        EndIf
    Next
    $File = FileOpen($LabelData, 1)
    FileWriteLine($File, $s)
    FileClose($File)
    MsgBox(0, "o^", "x  """ & $s & """  o^܂D", 1)
    Exit
EndFunc

Func LabelList($t)
    Global $Labels, $Items
    If $DicType < 3 Then
        If $t = 0 Then WriteString("{}%L%")
        If $WDir <> "" Then
            $File = FileOpen($LabelData, 0)
            $s = FileRead($File)
            FileClose($File)
            $Labels = StringSplit($s, @CRLF, 3)
            $Items = UBound($Labels) - 1
            $Labels[$Items] = "Xg̍XV"
            SetMenuPos(100, 155)
            HotKeySet("{ENTER}", "GetItem")
            HotKeySet("{SPACE}", "MoveDown")
            HotKeySet("+{SPACE}", "MoveUp")
            $PopUpListWindow = GUICreate("", 100, 155, $MenuLeft, $MenuTop, $WS_POPUP, -1, $Handle)
            $ListView = GUICtrlCreateListView("", 0, 0, 100, 155, $LVS_LIST)
            For $i = 0 to $Items
                GUICtrlCreateListViewItem($Labels[$i], $ListView)
            Next
            GUISetState()
            MoveDown()
            $ListContinue = True
            While $ListContinue
                $Msg = GUIGetMsg()
                Switch $Msg
                    Case $ListView + 1 To $ListView + $Items + 1
                        ExitLoop
                    Case $GUI_EVENT_CLOSE
                        Exit
                EndSwitch
            WEnd
            HotKeySet("{ENTER}")
            HotKeySet("{SPACE}")
            HotKeySet("+{SPACE}")
            $n = GUICtrlRead($ListView) - $ListView - 1
            GUIDelete($PopUpListWindow)
            Delay()
            If $n = $Items Then
                MakeLabelList(1)
                LabelList(1)
            Else
                SimpleWrite($Labels[$n])
                ControlSend($Handle, "", "", "{RIGHT}")
            EndIf
        EndIf
    EndIf
    Exit
EndFunc

; sI[h -------------------------------------------------------------
Func LineSelection()
    Global $LastIsNewlineChar, $OldCsString, $FirstLine0, $LastLine0, $Data0, $IndentAmountA, $IndentAmountB, $IndentAmountC, $SelectionModeWindow, $EditEnv, $EType, $HisList, $EnvStr, $Indent, $Continue
    If StringRight($Data, $NLLen) = $NL Then
        $LastIsNewlineChar = True
        $Data = StringTrimRight($Data, $NLLen)
    Else
        $LastIsNewlineChar = False
    EndIf
    $ShowAll = False
    $i = StringInStr($Data, $NL)
    If $i > 0 Then
        $FirstLine = StringLeft($Data, $i - 1)
        $ResultFirst = StringRegExp($FirstLine, "^( *\\begin{)(.+?)}.*", 3)
        If $ResultFirst <> $NoMatches Then
            $j = StringInStr($Data, $NL, 0, -1)
            $LastLine = StringTrimLeft($Data, $j + $NLLen - 1)
            $ResultLast = StringRegExp($LastLine, "^( *\\end{)(.+?)}.*", 3)
            If $ResultLast <> $NoMatches Then
                If $ResultFirst[1] = $ResultLast[1] Then
                    $ShowAll = True
                    $OldCsString = $ResultFirst[1]
                    $FirstLine0 = $ResultFirst[0]
                    $LastLine0 = $ResultLast[0]
                    $Data0 = StringTrimLeft($Data, StringLen($FirstLine))
                    $Data0 = StringTrimRight($Data0, StringLen($LastLine) + $NLLen)
                EndIf
            EndIf
        EndIf
    EndIf
    HotKeySet($Shortcut, "CompletionOnLineSelectionWindow")
    HotKeySet("{ENTER}", "ExecutionOnLineSelectionWindow")
    $CsType = 0
    $IndentAmountA = $EnvIndent
    $IndentAmountB = -$EnvIndent
    $IndentAmountC = 0
    $SelectionModeWindow = GUICreate("sI[h", 200, 270, -1, -1, $WS_CAPTION + $WS_SYSMENU, -1, $Handle)
    $EditEnv = GUICtrlCreateCheckbox(" ", 15, 15, 60)
    $EnvType = GUICtrlCreateCombo("}", 80, 15, 100, 20)
    If $ShowAll Then GUICtrlSetData(-1, "ύX|폜") 
    $EType = 1
    GUICtrlCreateLabel("", 35, 44, 40, 20)
    $HisList = ""
    If $MaxEnv > 0 Then $HisList = GetHistory("Env")
    If $HisList <> "" Then
        $s = StringSplit($HisList, ",")
        $HisList = $s[1]
        $EnvStr = GUICtrlCreateCombo("", 80, 40, 100)
        GUICtrlSetData(-1, $HisList, $s[2])
    Else
        $EnvStr = GUICtrlCreateInput("", 80, 40, 100)
    EndIf
    GUICtrlCreateLabel("I͈͂̃Cfg", 15, 79, 120)
    If $DicType < 3 Then
        $Indent = GUICtrlCreateInput($IndentAmountA, 138, 75, 40)
    Else
        $Indent = GUICtrlCreateInput($IndentAmountC, 138, 75, 40)
    EndIf
    $UpDown = GUICtrlCreateUpdown($Indent, $UDS_SETBUDDYINT)
    GUICtrlSetLimit($UpDown, $MaxIndent, -$MaxIndent)
    GUICtrlCreateLabel("i}CiX͍s폜j", 15, 100, 120)
    $Completion = GUICtrlCreateButton("⊮", 30, 130, 60, 22)
    $Execution = GUICtrlCreateButton("s", 110, 130, 60, 22)
    $CommentOn = GUICtrlCreateButton("Rgt", 50, 190, 100, 22)
    $CommentOff = GUICtrlCreateButton("Rg폜", 50, 220, 100, 22)
    $CommentStr = "%"
    If $CommentType = 2 Then $CommentStr &= " "
    If $DicType < 3 Then
        Check($EditEnv)
        Focus($EnvStr)
    Else
        Hide($EditEnv, 3)
        Hide($Completion, 0)
        Focus($Indent)
    EndIf
    GUISetState()
    $ParentWindowHandle = ControlGetHandle("[ACTIVE]", "", "")
    Lock()
    $ShowChild = False
    $Continue = True
    While $Continue
        $Msg = GUIGetMsg()
        Switch $Msg
            Case $EditEnv
                $x = GUICtrlRead($Indent)
                If GUICtrlRead($EditEnv) = $GUI_CHECKED Then
                    If $x <> "" Then $IndentAmountC = $x
                    Show($EnvType, 0)
                    Switch $EType
                        Case 1
                            Show($EnvStr - 1, 1)
                            Show($Completion, 0)
                            Show($Indent - 1, 3)
                            GUICtrlSetData($Indent, $IndentAmountA)
                        Case 2
                            Show($EnvStr - 1, 1)
                            Show($Completion, 0)
                            Hide($Indent - 1, 3)
                        Case 3
                            Hide($EnvStr - 1, 1)
                            Hide($Completion, 0)
                            Show($Indent - 1, 3)
                            GUICtrlSetData($Indent, $IndentAmountB)
                    EndSwitch
                    Focus($EnvType)
                Else
                    If $x <> "" Then
                        If $EType = 1 Then
                            $IndentAmountA = $x
                        ElseIf $EType = 3 Then
                            $IndentAmountB = $x
                        EndIf
                    EndIf
                    Hide($EnvType, 0)
                    Hide($EnvStr - 1, 1)
                    Hide($Completion, 0)
                    Show($Indent - 1, 3)
                    GUICtrlSetData($Indent, $IndentAmountC)
                    Focus($Indent)
                EndIf
            Case $EnvType
                $x = GUICtrlRead($Indent)
                Switch GUICtrlRead($EnvType)
                    Case "}"
                        If $EType = 3 AND $x <> "" Then $IndentAmountB = $x
                        $EType = 1
                        Show($EnvStr - 1, 1)
                        Show($Completion, 0)
                        Show($Indent - 1, 3)
                        GUICtrlSetData($Indent, $IndentAmountA)
                    Case "ύX"
                        If $x <> "" Then
                            If $EType = 1 Then
                                $IndentAmountA = $x
                            ElseIf $EType = 3 Then
                                $IndentAmountB = $x
                            EndIf
                        EndIf
                        $EType = 2
                        Show($EnvStr - 1, 1)
                        Show($Completion, 0)
                        Hide($Indent - 1, 3)
                    Case "폜"
                        If $EType = 1 AND $x <> "" Then $IndentAmountA = $x
                        $EType = 3
                        Hide($EnvStr - 1, 1)
                        Hide($Completion, 0)
                        Show($Indent - 1, 3)
                        GUICtrlSetData($Indent, $IndentAmountB)
                EndSwitch
            Case $Completion
                CompletionOnLineSelectionWindow()
            Case $Execution
                ExecutionOnLineSelectionWindow()
            Case $CommentOn
                If $LastIsNewlineChar Then $Data &= $NL
                $Data = StringRegExpReplace($Data, "(^|[\r\n])([^\r\n])", "\1" & $CommentStr & "\2")
                $Continue = False
            Case $CommentOff
                If $LastIsNewlineChar Then $Data &= $NL
                $Data = $NL & $Data
                $Data = StringReplace($Data, $NL & $CommentStr, $NL)
                $Data = StringTrimLeft($Data, $NLLen)
                $Continue = False
            Case $GUI_EVENT_CLOSE
                Unlock()
                GUIDelete($SelectionModeWindow)
                If $ShowChild Then WinActivate($Handle)
                ControlSend($Handle, "", "", $CancelKey)
                Exit
        EndSwitch
    WEnd
    GUIDelete($SelectionModeWindow)
    Unlock()
    WinActivate($Handle)
    SimpleWrite($Data)
    Exit
EndFunc

Func CompletionOnLineSelectionWindow()
    If GUICtrlRead($EditEnv) = $GUI_UNCHECKED  OR $Etype = 3 Then Return
    Global $CompleteCs
    $CompleteCs = ""
    GetCompleteCs(GUICtrlRead($EnvStr), 1)
    If $CompleteCs <> "" Then
        If $HisList <> "" Then
            GUICtrlSetData($EnvStr, $CompleteCs, $CompleteCs)
        Else
            GUICtrlSetData($EnvStr, $CompleteCs)
        EndIf
    EndIf
    HotKeySet($Shortcut, "CompletionOnLineSelectionWindow")
    HotKeySet("{ENTER}", "ExecutionOnLineSelectionWindow")
EndFunc

Func ExecutionOnLineSelectionWindow()
    If GUICtrlGetState($EnvStr) = $GUI_SHOW + $GUI_ENABLE Then
        $CsString = GUICtrlRead($EnvStr)
        If StringRegExp($CsString, "^[a-zA-Z]+\*?$", 0) = 0 Then Return
    EndIf
    If GUICtrlGetState($Indent) = $GUI_SHOW + $GUI_ENABLE Then
        $x = GUICtrlRead($Indent)
        If $x = "" Then
            If GUICtrlRead($EditEnv) = $GUI_CHECKED Then
                If $EType = 1 Then
                    GUICtrlSetData($Indent, $IndentAmountA)
                ElseIf $EType = 3 Then
                    GUICtrlSetData($Indent, $IndentAmountB)
                EndIf
            Else
                GUICtrlSetData($Indent, $IndentAmountC)
            EndIf
            Return
        EndIf
        If $x > $MaxIndent Then
            GUICtrlSetData($Indent, $MaxIndent)
            Return
        EndIf
        If $x < -$MaxIndent Then
            GUICtrlSetData($Indent, -$MaxIndent)
            Return
        EndIf
    EndIf
    If GUICtrlRead($EditEnv) = $GUI_UNCHECKED Then $EType = 0
    If $EType = 2 Then
        If $CsString = $OldCsString Then Return
        If Confirm($OldCsString & "  " & $CsString & " ɕύX܂H") Then Return
        $Data = $FirstLine0 & $CsString & "}" & $Data0 & $NL & $LastLine0 & $CsString & "}"
    Else
        If $EType = 3 Then
            If Confirm("ŏƍŌ̍s폜܂H") Then Return
            $Data = $Data0
        Else
            $Data = $NL & $Data
        EndIf
        If $x <> 0 AND $Data <> "" Then IndentOnOff($x)
        If $EType = 1 Then
            $Data = "\begin{" & $CsString & "}" & $Data & $NL & "\end{" & $CsString & "}"
        Else
            $Data = StringTrimLeft($Data, $NLLen)
        EndIf
    EndIf
    If $LastIsNewlineChar AND $Data <> "" Then $Data &= $NL
    If ($EType = 1 OR $EType = 2) AND $MaxEnv > 0 Then RenewHistory("Env", $HisList, $CsString, $MaxEnv)
    $Continue = False
EndFunc

Func Confirm($s)
    $ShowChild = True
    HotKeySet("{ENTER}")
    $YN = MsgBox(4, "mF", $s, 0, $ParentWindowHandle)
    $Result = ($YN = 7)
    HotKeySet("{ENTER}", "ExecutionOnLineSelectionWindow")
    Return $Result
EndFunc

Func IndentOnOff($n)
    If $n > 0 Then
        $s = SetSpaces($n)
        $Data = StringReplace($Data, $NL, $NL & $s)
    Else
        $s = ""
        While $Data <> ""
            $i = StringInStr($Data, $NL, 0, -1)
            $t = StringTrimLeft($Data, $i + $NLLen - 1)
            $Data = StringLeft($Data, $i - 1)
            $i = 0
            While $i < -$n AND $t <> ""
                If Asc(StringLeft($t, 1)) < 128 Then
                    $i += 1
                Else
                    $i += 2
                EndIf
                $t = StringTrimLeft($t, 1)
            WEnd
            If $i > -$n Then $t = " " & $t
            $s = $NL & $t & $s
        WEnd
        $Data = $s
    EndIf
EndFunc

; I[h ---------------------------------------------------------
Func StringSelection()
    Global $SelectionModeWindow, $TypeA, $TypeB, $HisListA, $HisListB, $CsStrA, $CsStrB, $Continue
    HotKeySet($Shortcut, "CompletionOnStringSelectionWindow")
    HotKeySet("{ENTER}", "ExecutionOnStringSelectionWindow")
    $CsType = 1
    SetMenuPos(230, 210)
    $SelectionModeWindow = GUICreate("I[h", 230, 210, $MenuLeft, $MenuTop, $WS_CAPTION + $WS_SYSMENU, -1, $Handle)
    $MenuLeft += 65
    $MenuTop += 56
    GUICtrlCreateLabel("Rg[V[PX̑}", 15, 15, 150)
    $TypeA = GUICtrlCreateRadio(" \", 15, 40, 30)
    $HisListA = ""
    If $MaxCsA > 0 Then $HisListA = GetHistory("CsA")
    If $HisListA <> "" Then
        $s = StringSplit($HisListA, ",")
        $HisListA = $s[1]
        $CsStrA = GUICtrlCreateCombo("", 45, 40, 100)
        GUICtrlSetData(-1, $HisListA, $s[2])
    Else
        $CsStrA = GUICtrlCreateInput("", 45, 40, 100)
    EndIf
    GUICtrlCreateLabel("{  }", 155, 44, 80)
    $TypeB = GUICtrlCreateRadio(" { \", 15, 65, 35)
    $HisListB = ""
    If $MaxCsB > 0 Then $HisListB = GetHistory("CsB")
    If $HisListB <> "" Then
        $s = StringSplit($HisListB, ",")
        $HisListB = $s[1]
        $CsStrB = GUICtrlCreateCombo("", 53, 65, 100)
        GUICtrlSetData(-1, $HisListB, $s[2])
    Else
        $CsStrB = GUICtrlCreateInput("", 53, 65, 100)
    EndIf
    GUICtrlCreateLabel("  }", 158, 69, 80)
    $Completion = GUICtrlCreateButton("⊮", 40, 100, 60, 22)
    $Execution = GUICtrlCreateButton("s", 130, 100, 60, 22)
    $ToEnv = GUICtrlCreateButton("Ƃēo^", 40, 160, 150, 22)
    Check($TypeA)
    Hide($CsStrB, 0)
    If $DicType = 3 OR StringRegExp($Data, "^[a-zA-Z]+\*?$", 0) = 0 OR StringLen($Data) > $MaxCsLen OR $Save = "No" Then Hide($ToEnv, 0)
    Focus($CsStrA)
    GUISetState()
    $ParentWindowHandle = ControlGetHandle("[ACTIVE]", "", "")
    Lock()
    $Continue = True
    While $Continue
        $Msg = GUIGetMsg()
        Switch $Msg
            Case $TypeA
                Hide($CsStrB, 0)
                Show($CsStrA, 0)
                Focus($CsStrA)
            Case $TypeB
                Hide($CsStrA, 0)
                Show($CsStrB, 0)
                Focus($CsStrB)
            Case $Completion
                CompletionOnStringSelectionWindow()
            Case $Execution
                ExecutionOnStringSelectionWindow()
            Case $ToEnv
                GUIDelete($SelectionModeWindow)
                If NotExistEnv($Data) Then
                    $YN = MsgBox(4, "o^", $Data & " ƂĎɓo^܂H", 0, $Handle)
                    If $YN = 6 Then SetData($EnvUserDic, $Data) ; YES
                Else
                    MsgBox(0, "o^ς", $Data & " ͂ł Env.usr ɓo^Ă܂D", 1)
                EndIf
                Unlock()
                WinActivate($Handle)
                Delay()
                ControlSend($Handle, "", "", $CancelKey)
                Exit
            Case $GUI_EVENT_CLOSE
                Unlock()
                GUIDelete($SelectionModeWindow)
                If $ShowChild Then WinActivate($Handle)
                ControlSend($Handle, "", "", $CancelKey)
                Exit
        EndSwitch
    WEnd
    GUIDelete($SelectionModeWindow)
    Unlock()
    WinActivate($Handle)
    SimpleWrite($Data)
    Exit
EndFunc

Func CompletionOnStringSelectionWindow()
    Global $CompleteCs
    $CompleteCs = ""
    If GUICtrlRead($TypeA) = $GUI_CHECKED Then
        $Current = $CsStrA
        $HisList = $HisListA
        $CompletionType = 2
    Else
        $Current = $CsStrB
        $HisList = $HisListB
        $CompletionType = 3
    EndIf
    GetCompleteCs(GUICtrlRead($Current), $CompletionType)
    If $CompleteCs <> "" Then
        If $HisList <> "" Then
            GUICtrlSetData($Current, $CompleteCs, $CompleteCs)
        Else
            GUICtrlSetData($Current, $CompleteCs)
        EndIf
    EndIf
    HotKeySet($Shortcut, "CompletionOnStringSelectionWindow")
    HotKeySet("{ENTER}", "ExecutionOnStringSelectionWindow")
EndFunc

Func ExecutionOnStringSelectionWindow()
    If GUICtrlRead($TypeA) = $GUI_CHECKED Then
        $CsString = GUICtrlRead($CsStrA)
        If StringRegExp($CsString, "^[a-zA-Z]+\*?$", 0) = 1 Then
            $Data = "\" & $CsString & "{" & $Data & "}"
            If $MaxCsA > 0 Then RenewHistory("CsA", $HisListA, $CsString, $MaxCsA)
            $Continue = False
        EndIf
    Else
        $CsString = GUICtrlRead($CsStrB)
        If StringRegExp($CsString, "^[a-zA-Z]+\*?$", 0) = 1 Then
            $Data = "{\" & $CsString & " " & $Data & "}"
            If $MaxCsB > 0 Then RenewHistory("CsB", $HisListB, $CsString, $MaxCsB)
            $Continue = False
        EndIf
    EndIf
EndFunc

Func NotExistEnv($s)
    $File = FileOpen($EnvUserDic, 0)
    $t = @CRLF & FileRead($File) & @CRLF
    FileClose($File)
    Return (StringRegExp($t, "\n" & $s & "(\r|\t.*\r)", 0) = 0)
EndFunc

; s╶I[h̗ -----------------------------------------------
Func GetHistory($s)
    $His = IniRead($HisFile, $s, "Recent", "")
    If $His <> "" Then
        $i = StringInStr($His & "|", "|")
        Return $His & "," & StringLeft($His, $i - 1)
    EndIf
    Return ""
EndFunc

Func RenewHistory($s, $t, $u, $n)
    If $t = "" Then
        $NewList = $u
    Else
        $a = "|" & $t & "|"
        $b = "|" & $u & "|"
        $i = StringInStr($a, $b, 1)
        Switch $i
            Case 0
                $NewList = $u & "|" & $t
            Case 1
                $NewList = $t
            Case Else
                $NewList = $u & StringLeft($a, $i - 1) & StringTrimLeft($a, $i + StringLen($u))
                $NewList = StringTrimRight($NewList, 1)
        EndSwitch
    EndIf
    If $NewList <> $t Then
        $i = StringInStr($NewList, "|", 0, $n)
        If $i > 0 Then $NewList = StringLeft($NewList, $i - 1)
        IniWrite($HisFile, $s, "Recent", $NewList)
    EndIf
EndFunc

; s╶I[hł̕⊮ ---------------------------------------------
Func GetCompleteCs($s, $t)
    $Result = StringRegExp($s, "^([a-zA-Z\-]+)(/)?(\*)?$", 3)
    If $Result <> $NoMatches Then
        $UseAt = "No"
        SearchCsStart($Result, 0, $t)
    EndIf
EndFunc

; hLgNX -------------------------------------------------------
Func Documentclass()
    Dim $DocumentClass[12] = ["jarticle", "jreport", "jbook", "tarticle", "treport", "tbook", "jsarticle", "jsbook", "slides", "article", "report", "book"]
    Dim $DocumentClassType[12] = [1, 1, 1, 1, 1, 1, 2, 2, 4, 3, 3, 3]
    Dim $ArtBookType[12] = [1, 1, 2, 1, 1, 2, 1, 2, 0, 1, 1, 2]
    Dim $ChapterType[12] = [-1, 1, 0, -1, 1, 0, -1, 0, -1, -1, 1, 0]
    Dim $TitlePage[12] = [False, True, True, False, True, True, False, True, True, False, True, True]
    Dim $PaperName[16] = ["a4paper", "a5paper", "b5paper", "b4paper", "a4j", "a5j", "b5j", "b4j", "a4var", "a6paper", "b5var", "b6paper", "a3paper", "letterpaper", "legalpaper", "executivepaper"]
    Dim $GraphicxOption[5] = ["[dvips]", "[dvipdfmx]", "[dvipdfm]", "[dviout]", ""]
    Dim $PageStyle[4] = ["empty", "plain", "headings", "myheadings"]
    $DocWindow = GUICreate("\documentclass", 660, 320, -1, -1, $WS_CAPTION + $WS_SYSMENU, -1, $Handle)
    GuiCtrlCreateGroup("NX", 10, 15, 310, 90)
    $jart  = GuiCtrlCreateRadio ("jarticle",   25,  35, 60)
             GuiCtrlCreateRadio ("jreport",    25,  55, 60)
             GuiCtrlCreateRadio ("jbook",      25,  75, 60)
             GuiCtrlCreateRadio ("tarticle",  100,  35, 60)
             GuiCtrlCreateRadio ("treport",   100,  55, 60)
             GuiCtrlCreateRadio ("tbook",     100,  75, 60)
    $jsart = GuiCtrlCreateRadio ("jsarticle", 175,  35, 60)
             GuiCtrlCreateRadio ("jsbook",    175,  55, 60)
             GuiCtrlCreateRadio ("slide(s)",  175,  75, 60)
             GuiCtrlCreateRadio ("article",   250,  35, 60)
             GuiCtrlCreateRadio ("report",    250,  55, 60)
             GuiCtrlCreateRadio ("book",      250,  75, 60)
    GuiCtrlCreateGroup("p", 10, 115, 310, 110)
    $a4    = GuiCtrlCreateRadio ("A4",         25, 135, 60)
             GuiCtrlCreateRadio ("A5",        100, 135, 60)
             GuiCtrlCreateRadio ("B5",        175, 135, 60)
             GuiCtrlCreateRadio ("B4",        250, 135, 60)
             GuiCtrlCreateRadio ("A4j",        25, 155, 60)
             GuiCtrlCreateRadio ("A5j",       100, 155, 60)
             GuiCtrlCreateRadio ("B5j",       175, 155, 60)
             GuiCtrlCreateRadio ("B4j",       250, 155, 60)
             GuiCtrlCreateRadio ("A4var",      25, 175, 60)
             GuiCtrlCreateRadio ("A6",        100, 175, 60)
             GuiCtrlCreateRadio ("B5var",     175, 175, 60)
             GuiCtrlCreateRadio ("B6",        250, 175, 60)
             GuiCtrlCreateRadio ("A3",         25, 195, 60)
             GuiCtrlCreateRadio ("letter",    100, 195, 60)
             GuiCtrlCreateRadio ("legal",     175, 195, 60)
             GuiCtrlCreateRadio ("executive", 250, 195, 65)
    GuiCtrlCreateGroup("TCY", 10, 235, 210, 70)
    $xpt   = GuiCtrlCreateRadio ("10pt",       25, 255, 50)
             GuiCtrlCreateRadio ("11pt",       95, 255, 50)
             GuiCtrlCreateRadio ("12pt",      165, 255, 50)
    $other = GuiCtrlCreateRadio ("̑",     25, 275, 50)
    $fsize = GUICtrlCreateCombo("9pt", 95, 276, 50)
    GUICtrlSetData(-1, "8pt|14pt|17pt|21pt|25pt|30pt|36pt|43pt|12Q|14Q")
    GuiCtrlCreateGroup("p̌", 230, 235, 90, 70)
             GuiCtrlCreateRadio ("cu", 245, 255, 60)
    $land  = GuiCtrlCreateRadio ("u", 245, 275, 60)
    GUIStartGroup()
    GUICtrlCreateLabel("^Cg", 340, 29, 60)
    $notit = GuiCtrlCreateRadio("Ȃ",               420, 25,  50)
             GuiCtrlCreateRadio("",               480, 25,  50)
             GuiCtrlCreateRadio("iƗy[Wj", 540, 25, 110)
    GUIStartGroup()
    GUICtrlCreateLabel("y[W", 340, 49, 60)
    $same  = GuiCtrlCreateRadio("ݒ", 440, 45, 100)
             GuiCtrlCreateRadio("ʐݒ",   540, 45, 100)
    GUIStartGroup()
    GUICtrlCreateLabel("͂̊Jn", 340, 69, 70)
    $openR = GuiCtrlCreateRadio("y[W", 440, 65, 80)
             GuiCtrlCreateRadio("w",     540, 65, 60)
    GUIStartGroup()
    GUICtrlCreateLabel("2 ig", 340, 89, 70)
             GuiCtrlCreateRadio("Ȃ", 440, 85, 60)
    $two   = GuiCtrlCreateRadio("",   540, 85, 60)
    GUIStartGroup()
    GUICtrlCreateLabel("I[o[tx", 340, 109, 100)
             GuiCtrlCreateRadio("Ȃ", 440, 105, 60)
    $draft = GuiCtrlCreateRadio("",   540, 105, 60)
    GUIStartGroup()
    GUICtrlCreateLabel("ʍs", 340, 129, 70)
             GuiCtrlCreateRadio("Z^O", 440, 125, 100)
    $left  = GuiCtrlCreateRadio("",       540, 125,  60)
    GuiCtrlCreateLabel("ǉIvV", 340, 149, 100)
    $psize = GUICtrlCreateCheckbox("papersize", 440, 145, 70)
    $up    = GUICtrlCreateCheckbox("uplatex",   540, 145, 70)
    GUIStartGroup()
    GUICtrlCreateLabel("y[WX^C", 340, 169, 100)
             GuiCtrlCreateRadio("empty",      440, 165,  60)
    $plain = GuiCtrlCreateRadio("plain",      540, 165,  60)
             GuiCtrlCreateRadio("headings",   440, 185, 100)
             GuiCtrlCreateRadio("myheadings", 540, 185, 100)
    GUIStartGroup()
    $graph = GUICtrlCreateCheckbox("graphicx pbP[Wǂݍށ@iȉ̓IvVj", 340, 210, 270)
             GuiCtrlCreateRadio("dvips",    360, 230, 70)
             GuiCtrlCreateRadio("dvipdfmx", 440, 230, 70)
             GuiCtrlCreateRadio("dvipdfm",  520, 230, 70)
             GuiCtrlCreateRadio("dviout",   360, 250, 70)
             GuiCtrlCreateRadio("w",   440, 250, 70)
    $ams   = GUICtrlCreateCheckbox("amsmath pbP[Wǂݍ",  340, 270, 170)
    $OK    = GUICtrlCreateButton("OK", 540, 280, 80)
    If $ClassName = 1 Then
        $Class = 0
        $ClassType = 1
        Check($jart)
        Hide($a4 + 8, 7)
        Hide($other, 2)
        Hide($psize - 1, 2)
    Else
        $Class = 6
        $ClassType = 2
        Check($jsart)
        Hide($fsize, 1)
    EndIf
    $PrevClassType = $ClassType
    $Paper = 0
    $Paper1 = 0
    $Paper2 = 0
    $Paper3 = 13
    Check($a4)
    $FontSize = 0
    $PrevSize = 0
    $Extra = False
    Check($xpt)
    Check($land - 1)
    $Title = 0
    $Title1 = 0
    $Title2 = 2
    Check($notit)
    $Side1 = 0
    $Side2 = 1
    Check($same)
    $Chapter1 = 0
    $Chapter2 = 1
    Check($openR)
    Hide($openR - 1, 2)
    Check($two - 1)
    Check($draft - 1)
    Check($left - 1)
    $Style = 1
    Check($plain)
    $GOption = 4
    Check($graph + 5)
    Hide($graph + 1, 4)
    Focus($OK)
    GUISetState()
    $ParentWindowHandle = ControlGetHandle("[ACTIVE]", "", "")
    $ShowChild = False
    While True
        $Msg = GUIGetMsg()
        Switch $Msg
            Case $jart To $jart + 11
                $Class = $Msg - $jart
                $ClassType = $DocumentClassType[$Class]
                If $ClassType <> $PrevClassType Then
                    Switch $ClassType
                        Case 1
                            Show($a4 + 3, 7)
                            $Paper = $Paper1
                            Check($a4 + $Paper)
                            Hide($a4 + 8, 7)
                            Show($xpt, 2)
                            Check($xpt + $PrevSize)
                            Hide($Other, 2)
                            $FontSize = $PrevSize
                            Hide($psize - 1, 2)
                        Case 2
                            Show($a4 + 3, 15)
                            $Paper = $Paper2
                            Check($a4 + $Paper)
                            If $Extra Then
                                Show($xpt, 5)
                                Check($other)
                                $FontSize = 3
                            Else
                                Show($xpt, 3)
                            EndIf
                            Show($psize - 1, 2)
                        Case Else
                            If $ClassType = 4 Then
                                $YN = MsgBox(4, "^Cv̎w", "jsarticle  slide IvVłH", 0, $ParentWindowHandle)
                                If $YN = 6 Then ; YES
                                    GUIDelete($DocWindow)
                                    WinActivate($Handle)
                                    WriteString("[slide,papersize]{jsarticle}%H\title{}%H\author{}%H\date{}%H\begin{document}%H\maketitle%H%H\section{}%H%H\end{document}%N%U8L2%")
                                    Exit
                                EndIf
                                $ShowChild = True
                            EndIf
                            Show($a4 + 13, 2)
                            $Paper = $Paper3
                            Check($a4 + $Paper)
                            Hide($a4 + 3, 9)
                            If $ClassType = 4 Then
                                Hide($xpt, 5)
                            Else
                                Show($xpt, 2)
                                Check($xpt + $PrevSize)
                                Hide($Other, 2)
                                $FontSize = $PrevSize
                            EndIf
                            Hide($psize - 1, 2)
                    EndSwitch
                EndIf
                $PrevClassType = $ClassType
                If $TitlePage[$Class] Then
                    $Title = $Title2
                    Check($notit + $Title)
                Else
                    $Title = $Title1
                    Check($notit + $Title)
                EndIf
                Switch $ArtBookType[$Class]
                    Case 1
                        Show($same - 1, 5)
                        Check($same + $Side1)
                    Case 2
                        Show($same - 1, 5)
                        Check($same + $Side2)
                    Case 0
                        Hide($same - 1, 5)
                EndSwitch
                Switch $ChapterType[$Class]
                    Case -1
                        Hide($openR - 1, 2)
                    Case 0
                        Show($openR - 1, 2)
                        Check($openR + $Chapter1)
                    Case 1
                        Show($openR - 1, 2)
                        Check($openR + $Chapter2)
                EndSwitch
            Case $a4 To $a4 + 15
                $Paper = $Msg - $a4
                Switch $Paper
                    Case 0 To 2
                        If $ClassType < 3 Then
                            $Paper1 = $Paper
                            $Paper2 = $Paper
                        Else
                            $Paper3 = $Paper
                        EndIf
                    Case 3 To 7
                        $Paper1 = $Paper
                        $Paper2 = $Paper
                    Case 8 To 12
                        $Paper2 = $Paper
                    Case 13 To 15
                        If $ClassType = 2 Then
                            $Paper2 = $Paper
                        Else
                            $Paper3 = $Paper
                        EndIf
                EndSwitch
            Case $xpt To $xpt + 3
                $FontSize = $Msg - $xpt
                If $FontSize = 3 Then
                    $Extra = True
                    Show($fsize, 1)
                Else
                    $PrevSize = $FontSize
                    If $ClassType = 2 Then $Extra = False
                    Hide($fsize, 1)
                EndIf
            Case $notit To $notit + 2
                $Title = $Msg - $notit
                If $TitlePage[$Class] Then
                    $Title2 = $Title
                Else
                    $Title1 = $Title
                EndIf
            Case $same To $same + 1
                $Side = $Msg - $same
                If $ArtBookType[$Class] = 1 Then
                    $Side1 = $Side
                Else
                    $Side2 = $Side
                EndIf
            Case $openR To $openR + 1
                $Chapter = $Msg - $openR
                If $ChapterType[$Class] = 0 Then
                    $Chapter1 = $Chapter
                Else
                    $Chapter2 = $Chapter
                EndIf
            Case $plain - 1 To $plain + 2
                $Style = $Msg - $plain + 1
            Case $graph
                If GUICtrlRead($graph) = $GUI_CHECKED Then
                    Show($graph + 1, 4)
                Else
                    Hide($graph + 1, 4)
                EndIf
            Case $graph + 1 To $graph + 5
                $GOption = $Msg - $graph - 1
            Case $OK
                ExitLoop
            Case $GUI_EVENT_CLOSE
                GUIDelete($DocWindow)
                If $ShowChild Then WinActivate($Handle)
                WriteString("{}%L%")
                Exit
        EndSwitch
    WEnd
    $s = ""
    If ($ClassType < 3 AND $Paper <> 0) OR ($ClassType > 2 AND $Paper <> 13) Then $s &= "," & $PaperName[$Paper]
    If $ClassType < 4 Then
        If $FontSize = 3 Then
            $t = GUICtrlRead($fsize)
            If $t <> "" Then $s &= "," & $t
        ElseIf $FontSize > 0 Then
            $s &= "," & $FontSize + 10 & "pt"
        EndIf
    EndIf
    If GUICtrlRead($land) = $GUI_CHECKED Then $s &= ",landscape"
    Switch $ArtBookType[$Class]
        Case 1
            If $Side1 = 1 Then $s &= ",twoside"
        Case 2
            If $Side2 = 0 Then $s &= ",oneside"
    EndSwitch
    Switch $ChapterType[$Class]
        Case 0
            If $Chapter1 = 1 Then $s &= ",openany"
        Case 1
            If $Chapter2 = 0 Then $s &= ",openright"
    EndSwitch
    If $ArtBookType[$Class] > 0 AND GUICtrlRead($two) = $GUI_CHECKED Then $s &= ",twocolumn"
    If $TitlePage[$Class] Then
        If $Title < 2 Then $s &= ",notitlepage"
    Else
        If $Title = 2 Then $s &= ",titlepage"
    EndIf
    If GUICtrlRead($draft) = $GUI_CHECKED Then $s &= ",draft"
    If GUICtrlRead($left) = $GUI_CHECKED Then $s &= ",fleqn"
    If $ClassType = 2 Then
        If GUICtrlRead($psize) = $GUI_CHECKED Then $s &= ",papersize"
        If GUICtrlRead($up) = $GUI_CHECKED Then $s &= ",uplatex"
    EndIf
    If $s <> "" Then $s = "[" & StringTrimLeft($s, 1) & "]"
    $s &= "{" & $DocumentClass[$Class] & "}"
    If GUICtrlRead($graph) = $GUI_CHECKED Then $s &= "%H\usepackage" & $GraphicxOption[$GOption] & "{graphicx}"
    If GUICtrlRead($ams) = $GUI_CHECKED Then $s &= "%H\usepackage{amsmath}"
    If $Style <> 1 Then $s &= "%H\pagestyle{" & $PageStyle[$Style] & "}"
    If $Title > 0 Then $s &= "%H\title{}%H\author{}%H\date{}"
    $s &= "%H\begin{document}"
    If $Class = 8 Then
        If $Title > 0 Then $s &= "%H\begin{slide}%J\maketitle%H\end{slide}%H"
        $s &= "%H\begin{slide}%J%H\end{slide}"
    Else
        If $Title > 0 Then $s &= "%H\maketitle"
    EndIf
    $s &= "%H%H\end{document}"
    GuiDelete($DocWindow)
    If $ShowChild Then WinActivate($Handle)
    Write($s)
    If $Class = 8 Then
        If $Title > 0 Then
            WriteString("%N%U13%%>%L%")
        Else
            WriteString("%N%U4%%>")
        EndIf
    Else
        If $Title > 0 Then
            WriteString("%N%U7%%>%L%")
        Else
            WriteString("%N%U2%")
        EndIf
    EndIf
    Exit
EndFunc

; t@CJ_CAO -------------------------------------------------
Func GetFileName($s)
    If $DicType < 3 Then
        WriteString("{}%L%")
    Else
        SimpleWrite(" ")
    EndIf
    $Opt = 1
    If $WDir <> "" Then
        Switch $s
            Case "input", "blackandwhite", "colorslides"
                $Filter = "TeX files (*.tex)|All(*.*)"
            Case "include"
                $Filter = "TeX files (*.tex)"
            Case "includeonly"
                $Filter = "TeX files (*.tex)"
                $Opt = 5
            Case "bibliography"
                $Filter = "Bib files (*.bib)"
                $Opt = 5
            Case "includegraphics"
                $Filter = "Images (*.eps;*.jpg)|Images2 (*.bmp;*.png;*.gif)|All(*.*)"
        EndSwitch
        $t = FileOpenDialog("t@C̎w", $WDir, $Filter, $Opt, "", $Handle)
        If $t <> "" Then
            $n = StringInStr($t, "|")
            If $n > 0 Then $t = StringReplace($t, "|", "\", 1)
            $t = StringReplace($t, $WDir, "")
            $t = StringReplace($t, "\", "/")
            $n = StringInStr($t, "|")
            If $n > 0 Then
                $n = StringInStr($t, "/", 0, -1)
                $Dir = StringLeft($t, $n)
                $t = StringReplace($t, "|", "," & $Dir)
                If $s = "bibliography" Then
                    $t = StringReplace($t, ".bib", "", 0, 2)
                Else
                    $t = StringReplace($t, ".tex", "", 0, 2)
                EndIf
            ElseIf $s = "includegraphics" Then
                Delay()
                ControlSend($Handle, "", "", "{LEFT}")
                SimpleWrite("[width=, clip]")
                ControlSend($Handle, "", "", "{RIGHT}")
                SimpleWrite($t)
                ControlSend($Handle, "", "", "{LEFT " & StringLen($t) + 8 & "}")
                Exit
            Else
                $u = StringLower(StringRight($t, 4))
                If $s = "bibliography" Then
                    If $u = ".bib" Then
                        $t = StringTrimRight($t, 4)
                    Else
                        MsgBox(4096, "G[", "Bib t@Cw肵ĂD", 1)
                        Exit
                    EndIf
                Else
                    If $u = ".tex" Then
                        $t = StringTrimRight($t, 4)
                    ElseIf $s <> "input" Then
                        MsgBox(4096, "G[", "TeX t@Cw肵ĂD", 1)
                        Exit
                    EndIf
                EndIf
            EndIf
            If $DicType < 3 Then
                SimpleWrite($t)
                WriteString("%R%%N")
            Else
                WriteString($t & "%N")
            EndIf
        EndIf
    EndIf
    Exit
EndFunc

; t@C̓o ---------------------------------------------------------
Func FileIO($s)
    $CS = InputBox("Xg[ԍ", "Xg[ԍ͂ĂD" & @CRLF & "ʏ̓Rg[V[PXw肵܂D", "", "", 250, 150, -1, -1, 0, $Handle)
    If $CS = "" Then Exit
    If StringLeft($CS, 1) <> "\" Then $CS = "\" & $CS
    $t = ""
    If $WDir <> "" Then
        If $s = "newread" Then
            $t = FileOpenDialog("t@CI", $WDir, "All(*.*)", 1, "", $Handle)
        Else
            $t = InputBox("t@C", "ރt@C͂ĂD", "", "", 250, 150, -1, -1, 0, $Handle)
        EndIf
        If $t <> "" Then
            $t = StringReplace($t, $WDir, "")
            $t = StringReplace($t, "\", "/")
        EndIf
    EndIf
    If $s = "newread" Then
        WriteString($CS & "%M\openin" & $CS & "=" & $t & "%M\read" & $CS & " to \%M\closein" & $CS & "%N")
    Else
        WriteString($CS & "%M\openout" & $CS & "=" & $t & "%M\write" & $CS & "{}%M\closeout" & $CS & "%N")
    EndIf
    If $t = "" Then
        WriteString("%U3%%>")
    Else
        WriteString("%U2%%>")
        If $s = "newwrite" Then WriteString("%L%")
    EndIf
    Exit
EndFunc

; \ -----------------------------------------------------------------------
Func Tabular($s, $a)
    If $a = 1 Then
        $t = $AddSpace & $AddSpace
    Else
        $t = ""
    EndIf
    $TabularWindow =  GUICreate($s, 300, 340, -1, -1, $WS_CAPTION + $WS_SYSMENU, -1, $Handle)
    GUICtrlCreateLabel("s̐", 15, 19, 50)
    $Row = GUICtrlCreateInput("", 70, 15, 40)
    $UpDownR = GUICtrlCreateUpdown($Row, $UDS_SETBUDDYINT)
    GUICtrlSetLimit($UpDownR, 10, 1)
    GUICtrlCreateLabel("̐", 150, 19, 50)
    $Col = GUICtrlCreateInput("", 205, 15, 40)
    $UpDownC = GUICtrlCreateUpdown($Col, $UDS_SETBUDDYINT)
    GUICtrlSetLimit($UpDownC, 10, 1)
    GuiCtrlCreateGroup("", 15, 55, 270, 105)
    GUICtrlCreateLabel("", 25, 75, 70)
    $RowS = GuiCtrlCreateRadio("Ȃ",  100,  73, 60)
    GuiCtrlCreateRadio("", 170, 73, 50)
    GUICtrlCreateLabel("", 25, 95, 70)
    GUIStartGroup()
    GuiCtrlCreateRadio("Ȃ", 100, 93, 60)
    GuiCtrlCreateRadio("", 170, 93, 50)
    $RowM = GUICtrlCreateLabel("1 sڂ̉", 25, 115, 70)
    GUIStartGroup()
    GuiCtrlCreateRadio("Ȃ", 100, 113, 60)
    GuiCtrlCreateRadio("", 170, 113, 45)
    GuiCtrlCreateRadio("2d", 220, 113, 60)
    $RowO = GUICtrlCreateLabel("̑", 25, 135, 70)
    GUIStartGroup()
    GuiCtrlCreateRadio("Ȃ", 100, 133, 60)
    GuiCtrlCreateRadio("", 170, 133, 50)
    GuiCtrlCreateGroup("c", 15, 175, 270, 105)
    GUICtrlCreateLabel("", 25, 195, 70)
    $ColS = GuiCtrlCreateRadio("Ȃ", 100, 193, 60)
    GuiCtrlCreateRadio("", 170, 193, 50)
    GUICtrlCreateLabel("E", 25, 215, 70)
    GUIStartGroup()
    GuiCtrlCreateRadio("Ȃ", 100, 213, 60)
    GuiCtrlCreateRadio("", 170, 213, 50)
    $ColM = GUICtrlCreateLabel("1 ڂ̉E", 25, 235, 70)
    GUIStartGroup()
    GuiCtrlCreateRadio("Ȃ", 100, 233, 60)
    GuiCtrlCreateRadio("", 170, 233, 45)
    GuiCtrlCreateRadio("2d", 220, 233, 60)
    $ColO = GUICtrlCreateLabel("̑", 25, 255, 70)
    GUIStartGroup()
    GuiCtrlCreateRadio("Ȃ", 100, 253, 60)
    GuiCtrlCreateRadio("", 170, 253, 50)
    $OK = GUICtrlCreateButton("OK", 120, 300, 60)
    GUICtrlSetData($Row, $RowNum)
    GUICtrlSetData($Col, $ColNum)
    $RA = StringMid($RowInfo, 1, 1)
    $RB = StringMid($RowInfo, 2, 1)
    $RC = StringMid($RowInfo, 3, 1)
    $RD = StringMid($RowInfo, 4, 1)
    $CA = StringMid($ColInfo, 1, 1)
    $CB = StringMid($ColInfo, 2, 1)
    $CC = StringMid($ColInfo, 3, 1)
    $CD = StringMid($ColInfo, 4, 1)
    Check($RowS + $RA)
    Check($RowS + $RD + 3)
    Check($RowS + $RB + 6)
    Check($RowS + $RC + 10)
    Check($ColS + $CA)
    Check($ColS + $CD + 3)
    Check($ColS + $CB + 6)
    Check($COlS + $CC + 10)
    If $RowNum < 3 Then
        Hide($RowO, 2)
        If $RowNum = 1 Then Hide($RowM, 3)
    EndIf
    If $ColNum < 3 Then
        Hide($ColO, 2)
        If $ColNum = 1 Then Hide($ColM, 3)
    EndIf
    Focus($OK)
    GUISetState()
    While True
        $NewRowNum = GUICtrlRead($Row)
        If $NewRowNum <> $RowNum Then
            $RowNum = $NewRowNum
            If $RowNum > 1 Then
                Show($RowM, 3)
            Else
                Hide($RowM, 3)
            EndIf
            If $RowNum > 2 Then
                Show($RowO, 2)
            Else
                Hide($RowO, 2)
            EndIf
        EndIf
        $NewColNum = GUICtrlRead($Col)
        If $NewColNum <> $ColNum Then
            $ColNum = $NewColNum
            If $ColNum > 1 Then
                Show($ColM, 3)
            Else
                Hide($ColM, 3)
            EndIf
            If $ColNum > 2 Then
                Show($ColO, 2)
            Else
                Hide($ColO, 2)
            EndIf
        EndIf
        $Msg = GUIGetMsg()
        Switch $Msg
            Case $RowS To $RowS + 1
                $RA = $Msg - $RowS
            Case $RowS + 3 To $RowS + 4
                $RD = $Msg - $RowS - 3
            Case $RowS + 6 To $RowS + 8
                $RB = $Msg - $RowS - 6
            Case $RowS + 10 To $RowS + 11
                $RC = $Msg - $RowS - 10
            Case $ColS To $ColS + 1
                $CA = $Msg - $ColS
            Case $ColS + 3 To $ColS + 4
                $CD = $Msg - $ColS - 3
            Case $ColS + 6 To $ColS + 8
                $CB = $Msg - $ColS - 6
            Case $ColS + 10 To $ColS + 11
                $CC = $Msg - $ColS - 10
            Case $OK
                If $RowNum < 1 Then
                    $RowNum = 1
                    GUICtrlSetData($Row, 1)
                    ContinueLoop
                EndIf
                If $RowNum > 10 Then
                    $RowNum = 10
                    GUICtrlSetData($Row, 10)
                    ContinueLoop
                EndIf
                If $ColNum < 1 Then
                    $ColNum = 1
                    GUICtrlSetData($Col, 1)
                    ContinueLoop
                EndIf
                If $ColNum > 10 Then
                    $ColNum = 10
                    GUICtrlSetData($Col, 10)
                    ContinueLoop
                EndIf
                ExitLoop
            Case $GUI_EVENT_CLOSE
                If $a = 1 Then
                    GUIDelete($TabularWindow)
                    Delay()
                    WriteString($t & "%U3%%>%L%")
                EndIf
                Exit
        EndSwitch
    WEnd
    $RowInfo = $RA & $RB & $RC & $RD
    $ColInfo = $CA & $CB & $CC & $CD
    IniWrite($IniFile, "Tabular", "RowNum",    $RowNum)
    IniWrite($IniFile, "Tabular", "ColumnNum", $ColNum)
    IniWrite($IniFile, "Tabular", "Row",       $RowInfo)
    IniWrite($IniFile, "Tabular", "Column",    $ColInfo)
    $RowStr = $t
    For $i = 1 To $ColNum - 1
        $RowStr &= " & "
    Next
    $Str = "%<%L%{"
    If $s = "tabular*" Then
        $Str &= "}{@{\extracolsep{\fill}}"
    ElseIf $s = "tabularx" Then
        $Str &= "}{"
    EndIf
    If $CA = 1 Then $Str &= "|"
    $Str &= "l"
    If $ColNum > 1 Then
        If $CB > 0 Then $Str &= "|"
        If $CB = 2 Then $Str &= "|"
    EndIf
    For $i = 1 To $ColNum - 2
        $Str &= "l"
        If $CC = 1 Then $Str &= "|"
    Next
    If $ColNum > 1 Then $Str &= "l"
    If $CD = 1 Then $Str &= "|"
    $Str &= "}%R%%>"
    If $RA = 1 Then $Str &= $t & "\hline%J"
    If $RowNum > 1 Then
        $Str &= $RowStr & " \\%J"
        If $RB = 1 Then $Str &= $t & "\hline%J"
        If $RB = 2 Then $Str &= $t & "\hline\hline%J"
        For $i = 1 To $RowNum - 2
            $Str &= $RowStr & " \\%J"
            If $RC = 1 Then $Str &= $t & "\hline%J"
        Next
    EndIf
    $Str &= $RowStr
    If $RD = 1 Then $Str &= " \\%J" & $t & "\hline"
    $Str &= "%R%"
    If $RowNum > 1 Then
        $n = $RowNum + ($RowNum - 2) * $RC + $RD
        If $RB > 0 Then $n += 1
    Else
        $n = $RD + 1
    EndIf
    If $s = "tabular" Then
        If $a = 1 Then
            $n += $RA + 3
            $m = 14
        Else
            $m = StringLen($LeftSpace) + $EnvIndent
        EndIf
    Else
        $n += $RA + 1
        $m = StringLen($LeftSpace) + 17
    EndIf
    If $m > 0 Then
        $Str &= "%U" & $n & "R" & $m & "%"
    Else
        $Str &= "%U" & $n & "%"
    EndIf
    GUIDelete($TabularWindow)
    WriteString($Str)
    Exit
EndFunc

Func Array($s, $a)
    $ArrayWindow = GUICreate($s, 260, 100, -1, -1, $WS_CAPTION + $WS_SYSMENU, -1, $Handle)
    GUICtrlCreateLabel("s̐", 15, 19, 50)
    $Row = GUICtrlCreateInput("", 70, 15, 40)
    $UpDownR = GUICtrlCreateUpdown($Row, $UDS_SETBUDDYINT)
    GUICtrlSetLimit($UpDownR, 10, 1)
    GUICtrlCreateLabel("̐", 150, 19, 50)
    $Col = GUICtrlCreateInput("", 205, 15, 40)
    $UpDownC = GUICtrlCreateUpdown($Col, $UDS_SETBUDDYINT)
    GUICtrlSetLimit($UpDownC, 10, 1)
    $OK = GUICtrlCreateButton("OK", 100, 60, 60)
    GUICtrlSetData($Row, $ArrayRowNum)
    GUICtrlSetData($Col, $ArrayColNum)
    Focus($OK)
    GUISetState()
    While True
        $Msg = GUIGetMsg()
        Switch $Msg
            Case $OK
                $ArrayRowNum = GUICtrlRead($Row)
                If $ArrayRowNum < 1 Then
                    $ArrayRowNum = 1
                    GUICtrlSetData($Row, 1)
                    ContinueLoop
                EndIf
                If $ArrayRowNum > 10 Then
                    $ArrayRowNum = 10
                    GUICtrlSetData($Row, 10)
                    ContinueLoop
                EndIf
                $ArrayColNum = GUICtrlRead($Col)
                If $ArrayColNum < 1 Then
                    $ArrayColNum = 1
                    GUICtrlSetData($Col, 1)
                    ContinueLoop
                EndIf
                If $ArrayColNum > 10 Then
                    $ArrayColNum = 10
                    GUICtrlSetData($Col, 10)
                    ContinueLoop
                EndIf
                ExitLoop
            Case $GUI_EVENT_CLOSE
                Exit
        EndSwitch
    WEnd
    IniWrite($IniFile, "Array", "RowNum",    $ArrayRowNum)
    IniWrite($IniFile, "Array", "ColumnNum", $ArrayColNum)
    $RowStr = ""
    For $i = 1 To $ArrayColNum - 1
        $RowStr &= " & "
    Next
    If $CsType = 1 Then
        $Str = "{"
        For $i = 1 To $ArrayRowNum
            $Str &= "%J" & $RowStr & " \cr"
        Next
        $Str &= "%M}%(%U" & $ArrayRowNum & "%"
    Else
        If $a = 1 Then
            $Str = "%<%L%{"
            For $i = 1 To $ArrayColNum
                $Str &= "c"
            Next
            $Str &= "}%R%%>"
        Else
            $Str = ""
        EndIf
        For $i = 1 To $ArrayRowNum - 1
            $Str &= $RowStr & " \\%J"
        Next
        $Str &= $RowStr & "%RU" & $ArrayRowNum & "%"
    EndIf
    $m = StringLen($LeftSpace) + $EnvIndent
    If $m > 0 Then $Str &= "%R" & $m & "%"
    GUIDelete($ArrayWindow)
    WriteString($Str)
    Exit
EndFunc
