;;;;;;;;;;;
; HappyTeX
;;;;;;;;;;;

$Version = "1.8b"
$Date = "2013/09/26"

; gp@
; >HappyTeX hoge[.tex] [sԍ [I𕶎]] [/s ܂ /j]

; 2dN̋֎~
$List = ProcessList("HappyTeX.exe")
If $List[0][0] > 1 Then Exit

#include <WindowsConstants.au3>
#include <GUIConstantsEx.au3>
#include <DDEML.au3>
#include <DDEMLClient.au3>

Opt("WinTitleMatchMode", 2)

Dim $PaperType[7]  = ["A4", "A5", "A3", "B4", "B5", "H", "Free"]
Dim $WidthList[6]  = [210, 148, 297, 257, 182, 100]
Dim $HeightList[6] = [297, 210, 420, 364, 257, 148]
$MessageNum = 19
Dim $Message[$MessageNum]
$TranslationMessageNum = 21
Dim $TranslationMessage[$TranslationMessageNum]
$NoMatches = 1
$ComSpec = @ComSpec & " /c "
$NL = @CRLF
If @OSVersion = "WIN_8" OR @OSVersion = "WIN_7" OR @OSVersion = "WIN_VISTA" Then
  $NL2 = $NL
  $BalloonTop = ""
  $LeftSpace = "@ "
Else
  $NL2 = $NL & $NL
  $BalloonTop = "" & $NL
  $LeftSpace = "@@"
EndIf
$MaxListNum = 10

; ݒ ini t@Cǂݍ ------------------------------------------
$ScriptDir = @ScriptDir
If StringLen($ScriptDir) > 3 Then $ScriptDir &= "\"
$IniFile = $ScriptDir & "HappyTeX.ini"
CheckFileExists($IniFile, "HappyTeX.ini")
$TeXbin        = IniRead($IniFile, "Program",  "TeXbin",         "")
If StringMid($TeXbin, 2, 1) = ":" Then
  $USB = False
  $dviout      = IniRead($IniFile, "Program",  "dviout",         "")
  $NotUseDviout = ($dviout = "")
Else ; USB ̏ꍇ
  $USB = True
  $NotUseDviout = True
  $ProgramsDir = StringLeft(@ScriptDir, StringInStr(@ScriptDir, "\", 0, -1))
  $TeXbin = $ProgramsDir & $TeXbin
  $cmdPath     = IniRead($IniFile, "Program", "cmd-Path",        "")
EndIf
$MessageType   = IniRead($IniFile, "Message",  "Type",           "")
$GSmain        = IniRead($IniFile, "Program",  "GSmain",         "")
$gsview        = IniRead($IniFile, "Program",  "gsview",         "")
$PdfViewer     = IniRead($IniFile, "Program",  "pdfviewer",      "")
$PdfViewerT    = IniRead($IniFile, "Program",  "pdfviewertitle", "")
$PdfLock       = IniRead($IniFile, "Program",  "pdflock",        "")
$Editor        = IniRead($IniFile, "Editor",   "Path",           "")
$EditorJump    = IniRead($IniFile, "Editor",   "LineNumOpt",     "")
$ArgOrder      = IniRead($IniFile, "Editor",   "ArgOrder",       "")
$Delay1        = IniRead($IniFile, "Delay",    "Delay1",         "")
$Delay2        = IniRead($IniFile, "Delay",    "Delay2",         "")
$Delay3        = IniRead($IniFile, "Delay",    "Delay3",         "")
$FontmapList   = IniRead($IniFile, "Font",     "FontmapList",    "")
$FontmapNum    = IniRead($IniFile, "Font",     "FontmapNum",     "")
$psFontmapList = IniRead($IniFile, "Font",     "psFontmapList",  "")
$psFontmapNum  = IniRead($IniFile, "Font",     "psFontmapNum",   "")
$NoEmbedType   = IniRead($IniFile, "Font",     "NoEmbedType",    "")
$EFontType     = IniRead($IniFile, "Font",     "EFontType",      "")
$EFont         = IniRead($IniFile, "Font",     "EFont",          "")
$Type          = IniRead($IniFile, "Typeset",  "Type",           "")
$TeXType       = IniRead($IniFile, "Typeset",  "TeX",            "")
$Output        = IniRead($IniFile, "Typeset",  "Output",         "")
$Process       = IniRead($IniFile, "Typeset",  "Process",        "")
$Confirm       = IniRead($IniFile, "Typeset",  "Confirm",        "")
$View          = IniRead($IniFile, "Typeset",  "View",           "")
$Active        = IniRead($IniFile, "Typeset",  "Active",         "")
$Warning       = IniRead($IniFile, "Typeset",  "Warning",        "")
$Encoding      = IniRead($IniFile, "Typeset",  "Encoding",       "")
$CheckPaper    = IniRead($IniFile, "Typeset",  "CheckPaper",     "")
$SetPaper      = IniRead($IniFile, "Typeset",  "SetPaper",       "")
$ShellEscape   = IniRead($IniFile, "Typeset",  "ShellEscape",    "")
$MendexOpt     = IniRead($IniFile, "Option",   "mendex",         "")
$MakeIndexOpt  = IniRead($IniFile, "Option",   "makeindex",      "")
$Paper         = IniRead($IniFile, "Paper",    "Size",           "")
$Orientation   = IniRead($IniFile, "Paper",    "Orientation",    "")
$Width         = IniRead($IniFile, "Paper",    "Width",          "")
$Height        = IniRead($IniFile, "Paper",    "Height",         "")
$PrevBaseFile  = IniRead($IniFile, "MainFile", "Base",           "")
$PrevDir       = IniRead($IniFile, "MainFile", "Directory",      "")
If $USB Then $Editor = $ProgramsDir & $Editor
If $PdfViewerT = "" Then $PdfViewerT = "/BaseName/.pdf" 
$Delay1 = $Delay1 * 1000
$Delay3 = $Delay3 * 1000
$n = StringInStr($FontmapList, "|", 0, $MaxListNum)
If $n > 0 Then $FontmapList = StringLeft($FontmapList, $n - 1)
$Fontmap = GetFontmap($FontmapList, $FontmapNum)
$n = StringInStr($psFontmapList, "|", 0, $MaxListNum)
If $n > 0 Then $psFontmapList = StringLeft($psFontmapList, $n - 1)
$psFontmap = GetFontmap($psFontmapList, $psFontmapNum)
If $EFontType = 1 Then
  $EFontStr = "14"
ElseIf $EFontType = 2 Then
  $EFontStr = "12"
Else
  $EFontStr = " 6"
EndIf

; bZ[W̐ݒ ---------------------------------------------------------
$MessageFile = $ScriptDir & "MessageData\" & $MessageType & ".dat"
$NotSet = True
If $MessageType <> "" AND $MessageType <> "Tokyo" AND FileExists($MessageFile) Then SetMessage($MessageFile)
If $NotSet Then SetMessage("")

; ̃`FbN -----------------------------------------------------------
$OptionsNum = $CmdLine[0]
If $OptionsNum = 0 Then
  MsgBox(4096, "gp@", "TeX t@C" & $Message[5] & $NL2 & "> HappyTeX  hoge[ .tex]  [sԍ  [I𕶎] ]  [/s  ܂  /j]")
  Exit
EndIf

$MenuMode = True
$JumpMode = False
If $OptionsNum > 1 Then
  $s = StringLower($CmdLine[$OptionsNum])
  If $s = "/s" Then
    $MenuMode = False
    $OptionsNum -= 1
  ElseIf $s = "/j" Then
    $MenuMode = False
    If $View = 1 Then $JumpMode = True
    $OptionsNum -= 1
  EndIf
EndIf

$WDir = @WorkingDir
If StringLen($WDir) > 3 Then $WDir &= "\"
$WDrive = StringLeft($WDir, 2)
$s = StringReplace($CmdLine[1], "/", "\")
If StringLower(StringRight($s, 4)) = ".tex" Then $s = StringTrimRight($s, 4)
If StringLeft($s, 1) = "\" Then
  $s = $WDrive & $s
ElseIf StringMid($s, 2, 2) <> ":\" Then
  If StringMid($s, 2, 1) = ":" Then
    If StringLeft($s, 2) = $WDrive Then
      $s = StringTrimLeft($s, 2)
    Else
      MsgBox(4096, "G[", "TeX t@C" & $Message[6])
      Exit
    EndIf
  EndIf
  $s = $WDir & $s
EndIf
$StartFile = $s & ".tex"
CheckFileExists($StartFile, "")
If $OptionsNum = 1 Then
  $LineNumber = ""
Else
  $LineNumber = $CmdLine[2]
  If $OptionsNum = 2 Then
    $SrcWord = ""
  Else
    $SrcWord = "/" & $CmdLine[3]
  EndIf
EndIf

; eݒ -----------------------------------------------------------------
If $MenuMode Then
  $t = StringInStr($StartFile, "\", 0, -1)
  $WorkingDir = StringLeft($StartFile, $t)
  $TeXFile = StringTrimLeft($StartFile, $t)
  $BaseFile = StringTrimRight($TeXFile, 4)
  FileChangeDir($WorkingDir)
  $SameParent = False
  GuessTeXType($TeXFile, True)
  If NOT $SameParent Then GuessEncoding()
  ShowMenu()
Else
  $WorkingDir = $PrevDir
  $BaseFile = $PrevBaseFile
  $TeXFile = $BaseFile & ".tex"
  $s = $WorkingDir & $TeXFile
  If StringLower($s) <> StringLower($StartFile) Then
    CheckFileExists($s, "et@C " & $s)
  EndIf
EndIf

$ShowProcess = IniRead($IniFile, "Typeset", "ShowProcess", "")
If $Confirm = 2 AND $ShowProcess = 1 Then
  $ConfirmStr = " & echo. & pause"
Else
  $ConfirmStr = ""
EndIf
$Encoding = IniRead($IniFile, "Typeset", "Encoding", "")
$CodeConvert = False
If $Encoding = "ascii" Then
  $Encoding = "sjis"
ElseIf $Encoding = "jis" OR $Encoding = "euc" Then
  $CodeConvert = True
EndIf
$Enc = " -kanji=" & $Encoding
$EncMendex = " -" & StringUpper(StringLeft($Encoding, 1))
If $Type = 1 Then
  Switch $TeXType
    Case 1
      $TeX = "platex -no-guess-input-enc" & $Enc & " -sjis-terminal -jobname=" & $BaseFile
      $Index = "mendex" & $EncMendex & " -T"
      If $MendexOpt <> "" Then $Index &= " " & MendexOpt
    Case 2
      $TeX = "uplatex -no-guess-input-enc -kanji=utf8 -sjis-terminal"
    Case 3
      $TeX = "lualatex"
    Case 4
      $TeX = "luajitlatex"
    Case 5
      $TeX = "xelatex"
    Case 6
      $TeX = "pdflatex"
  EndSwitch
  If $TeXType > 2 Then
    $Index = "makeindex"
    If $MakeIndexOpt <>"" Then $Index &= " " & $MakeIndexOpt
  EndIf
  If $TeXType = 1 Then
    $Bib = "pbibtex"
    $BibTeX = $Bib & $Enc & " -sjis-terminal"
  ElseIf $TeXType = 2 Then
    $Bib = "upbibtex"
    $BibTeX = $Bib & " -kanji=utf8 -sjis-terminal"
  Else
    $Bib = "bibtex"
    $BibTeX = $Bib
  EndIf
Else
  Switch $TeXType
    Case 1
      $TeX = "eptex -no-guess-input-enc" & $Enc & " -sjis-terminal -jobname=" & $BaseFile
    Case 2
      $TeX = "euptex -no-guess-input-enc -kanji=utf8 -sjis-terminal"
    Case 3
      $TeX = "luatex"
    Case 4
      $TeX = "luajittex"
    Case 5
      $TeX = "xetex"
    Case 6
      $TeX = "pdftex"
  EndSwitch
EndIf
$TeX &= " -halt-on-error"
If $ShellEscape = 2 Then $TeX &= " -shell-escape"
If $Output = 4 AND $View = 1 Then $TeX &= " -src-specials"

$LogFile     = $BaseFile & ".log"
$AuxFile     = $BaseFile & ".aux" ; LaTeX
$TocFile     = $BaseFile & ".toc" ; LaTeX
$LofFile     = $BaseFile & ".lof" ; LaTeX
$LotFile     = $BaseFile & ".lot" ; LaTeX
$IdxFile     = $BaseFile & ".idx" ; LaTeX
$BblFile     = $BaseFile & ".bbl" ; LaTeX
$BlgFile     = $BaseFile & ".blg" ; LaTeX
$DviFile     = $BaseFile & ".dvi"
$SyncFile    = $BaseFile & ".synctex"
$PsFile      = $BaseFile & ".ps"
$PdfFile     = $BaseFile & ".pdf"
$FullPdfFile = $WorkingDir & $PdfFile
$PdfViewerT  = StringReplace($PdfViewerT, "/BaseName/", $BaseFile)

; USB  Ŏgꍇ̐ݒ ----------------------------------------------
If $USB Then
  $GSmain = $ProgramsDir & $GSmain
  $gsview = $ProgramsDir & $gsview
  If StringLower(StringRight($PdfViewer, 12)) <> "acrord32.exe" Then $PdfViewer = $ProgramsDir & $PdfViewer
  $s = StringTrimRight($TeXbin, 3)
  $TeXfontsTTF = $s & "share\texmf-local\fonts\truetype;" & $s & "share\texmf-dist\fonts\truetype"
  $GSfonts = StringLeft($GSmain, StringInStr($GSmain, "\", 0, -1)) & "fonts"
  $t = StringInStr($gsview, "\", 0, -1)
  $gsview = StringLeft($gsview, $t) & "gsview\gsview32.exe"
  $gsviewIniFile = StringLeft($gsview, $t) & "gsview\gsview32.ini"
  If $cmdPath Then
    $AdditionalPath = StringReplace(";" & $cmdPath, ";", ";" & $ProgramsDir)
  Else
    $AdditionalPath = ""
  EndIf
  $OrigPath = EnvGet("PATH")
  EnvSet("PATH", $TeXbin & ";" & $GSmain & "\bin;" & $GSmain & "\lib" & $AdditionalPath & ";" & $OrigPath)
  EnvSet("GS_LIB", $GSmain & "\Resource\Init;" & $GSmain & "\Resource;" & $GSmain & "\lib;" & $GSmain & "\kanji;" & $GSfonts & ";" & $TeXfontsTTF & ";C:\WINDOWS\fonts")
Else
  $gsviewIniFile = @UserProfileDir & "\" & "gsview32.ini"
EndIf

; Jump [h̐ݒ --------------------------------------------------------
$n = StringLen($WorkingDir)
If StringLeft($StartFile, $n) = $WorkingDir Then
  $StartFile = StringTrimLeft($StartFile, $n)
EndIf
$StartFile = StringReplace($StartFile, "\", "/")
FileChangeDir($WorkingDir)
If $View = 1 Then
  Switch $Output
    Case 1 To 3 ; PDF
      $PdfOpen = IniRead($IniFile, "Program", "pdfopen", "")
      $PdfJump = IniRead($IniFile, "Program", "pdfjump", "")
      $Synchro = True
      If $PdfJump = "same" OR $PdfJump = "new" Then
        $PdfJumpType = $PdfJump
        $PdfJump = $PdfOpen
      Else
        $PdfJumpType = "dde"
      EndIf
      If $LineNumber <> "" Then
        If $PdfJumpType = "dde" Then
          $Result = StringSplit($PdfJump, "/")
          $Service = $Result[1]
          $Topic = $Result[2]
          $PdfJump = StringTrimLeft($PdfJump, StringLen($Service & $Topic) + 2)
          If (NOT StringInStr($PdfJump, "%p")) AND (NOT StringInStr($PdfJump, "%q")) Then
            $SyncFile &= ".gz"
            $PdfJumpType = "ddesynctex"
            $PdfJump = StringReplace($PdfJump, "%f", $PdfFile)
            $PdfJump = StringReplace($PdfJump, "%t", $StartFile)
            $PdfJump = StringReplace($PdfJump, "%l", $LineNumber)
          EndIf
        Else
          If (NOT StringInStr($PdfJump, "%p")) AND (NOT StringInStr($PdfJump, "%q")) Then $Synchro = False
        EndIf
      EndIf
      If $JumpMode AND WinExists($PdfViewerT, "") Then
        $SetDelay = False
        If $Synchro AND FileExists($SyncFile) AND $LineNumber <> "" Then
          If $PdfJumpType = "ddesynctex" Then
            _DDE_Execute($Service, $Topic, $PdfJump)
          Else
            $PdfJump = SetPDFCommand($PdfJump)
            If $PdfJumpType = "dde" Then
              _DDE_Execute($Service, $Topic, $PdfJump)
            Else
              If $PdfJumpType = "new" Then
                WinClose($PdfViewerT, "")
                $SetDelay = True
              EndIf
              Run($PdfViewer & " " & $PdfJump)
            EndIf
          EndIf
        EndIf
        If $Active = 1 Then
          WinActivate($PdfViewerT, "")
        Else
          If $SetDelay Then Sleep($Delay3)
          WinActivate($TeXFile, "")
        EndIf
        Exit
      EndIf
      If $PdfJumpType = "ddesynctex" Then
        $TeX &= " -synctex=1"
      Else
        $TeX &= " -synctex=-1"
      EndIf
    Case 4 ; dvi
      If $LineNumber <> "" Then
        $SrcCommand = "[PageOpen(# " & $LineNumber & $SrcWord & " '" & $StartFile & "')][WinNormal][FileOpen(" & $DviFile & ")]"
      Else
        $SrcCommand = ""
      EndIf
      If $JumpMode AND WinExists($DviFile) Then
        If $SrcCommand Then _DDE_Execute("dviout", "dviout", $SrcCommand)
        If $Active = 1 Then
          WinActivate($DviFile, "")
        Else
          WinActivate($TeXFile, "")
        EndIf
        Exit
      EndIf
    Case 5 ; ps
      If $JumpMode AND WinExists($PsFile) Then
        If FileExists($SyncFile) AND $LineNumber <> "" Then
          $Page = ViewerPage()
          _DDE_Execute("GSview", "GSview", "[GotoPage(" & $Page & ")]")
        EndIf
        If $Active = 1 Then
          WinActivate($PsFile, "")
        Else
          WinActivate($TeXFile, "")
        EndIf
        Exit
      EndIf
      $TeX &= " -synctex=-1"
  EndSwitch
EndIf

; pTCY̐ݒ ---------------------------------------------------------
If $Output <> 3 AND ($Output <> 4 OR $View = 1) Then
  $dvioutOption = ""
  $dvipdfmxOption = ""
  $dvipsOption = ""
  $gsviewOption = ""
  $gsOption = ""
  $gsOption2 = ""
  $CheckSize = True
  If $SetPaper = 1 Then SetPapersizeOption()
  SetFont()
EndIf

; bZ[W̐ݒij----------------------------------------------------
If $TeXType < 3 Then
  $s = "dvi"
Else
  $s = "PDF"
EndIf
$Message[2] = $s & " " & $Message[2]
$Message[3] = $s & " t@C̍쐬 Warning " & $Message[3]
$AdditionalMessage = $NL2 & "log t@C" & $Message[4] & $NL2 & "\Ȃꍇ ESC ܂ LZ"
For $i = 0 To 3
  $Message[$i] &= $AdditionalMessage
Next

; ^CvZbg -------------------------------------------------------------
$RepeatNumber = 0
$MaxRepeatNumber = 6
$MakeIndexMode = ($TeXType <> 2)
If $ShowProcess = 1 Then
  $Mode = @SW_SHOW
  If $Process = 2 Then IniWrite($IniFile, "Typeset", "ShowProcess", 2)
Else
  $Mode = @SW_HIDE
EndIf
If $TeXType > 2 AND ($PdfLock = "Yes") Then WinClose($PdfViewerT, "")
If $MenuMode Then FileDelete ($AuxFile)
TrayTip("", $BalloonTop & "HappyTeX " & $Message[7] & $NL2 & $Message[8] & $NL, 30)
While True
  $RepeatNumber += 1
  RunWait($ComSpec & $TeX & " " & $TeXFile, "", $Mode)
  If $CodeConvert Then
    FileMove($LogFile, $LogFile & "." & $Encoding, 1)
    RunWait($ComSpec & "nkf -s " & $LogFile & "." & $Encoding & ">" & $LogFile, "", @SW_HIDE)
  EndIf
  $File = FileOpen($LogFile, 0)
  $Log = FileRead($File)
  FileClose($File)
  $LogTail = StringRight($Log, 2000)
  $Errors = StringRegExp($LogTail, "\n((!.*)\n(?:.*\n)*l.(\d+).*)\n", 3)
  If $Errors <> $NoMatches Then
    $s = StringLeft($Log, StringInStr($Log, $Errors[0]) - 1)
    $ErrorString  = $Errors[0]
    $ErrorMessage = $Errors[1]
    $ErrorLineNum = $Errors[2]
    Do
      $t = $s
      $s = StringRegExpReplace($t, "\([^()]*\)", "")
    Until $s = $t
    $s = StringRegExp($s, "\(([^(]*?)\n[^(]*$", 3)
    If $s = $NoMatches Then Halt(0)
    $ErrorFile = $s[0]
    If StringLeft($ErrorFile, 2) = "./" Then
      $ErrorFile = $WorkingDir & StringTrimLeft($ErrorFile, 2)
    ElseIf StringMid($ErrorFile, 2, 1) <> ":" Then ; sȃt@C
      Halt(0)
    EndIf
    $ErrorFile = StringReplace($ErrorFile, "/", "\")
    $LineOption = StringReplace($EditorJump, "*", $ErrorLineNum)
    If $ArgOrder = 1 Then
      RunWait($Editor & " " & $LineOption & " " & $ErrorFile)
    Else
      RunWait($Editor & " " & $ErrorFile & " " & $LineOption)
    EndIf
    Send("{SHIFTDOWN}{DOWN}{SHIFTUP}")
    MsgBox(48, "G[", Translate($ErrorMessage) & $ErrorString)
    WinWaitClose("G[")
    Send("{UP}")
    Exit
  EndIf
  If $Type = 1 AND $View <> 2 Then
    If $RepeatNumber = 1 Then
      If $MenuMode AND StringInStr($Log, $BblFile) Then
        $YN = MsgBox(52, "Ql", "`" & $Bib & ".exe' ŎQlXg" & $Message[9])
        If $YN = 6 Then ; Yes
          RunWait($ComSpec & $BibTeX & " " & $BaseFile, "", $Mode)
          $File = FileOpen($BlgFile, 0)
          $Blg = FileRead($File)
          FileClose($File)
          If StringInStr($Blg, "(Error may have been on previous line)") Then
            MsgBox(4096, "G[", "f[^x[Xt@C" & $Message[10] & $NL & $Message[11] & "ڂ `" & $BlgFile & "' " & $Message[12])
          EndIf
          ContinueLoop ;  JԂ
        EndIf
      EndIf
      If StringInStr($Log, $TocFile) Then ContinueLoop ;  JԂ
      If StringInStr($Log, $LofFile) Then ContinueLoop ;  JԂ
      If StringInStr($Log, $LotFile) Then ContinueLoop ;  JԂ
      If StringInStr($Log, " Rerun to get ") Then ContinueLoop ;  JԂ
    EndIf
    If StringInStr($Log, @LF & "LaTeX Warning: Label(s)") Then
      If $RepeatNumber = $MaxRepeatNumber Then Halt(1)
      ContinueLoop ;  JԂ
    EndIf
    If $MakeIndexMode Then
      $MakeIndexMode = False
      If StringInStr($Log, $IdxFile) Then
        RunWait($ComSpec & $Index & " " & $IdxFile, "", $Mode)
        ContinueLoop ;  JԂ
      EndIf
    EndIf
  EndIf
  ExitLoop
WEnd

If NOT StringInStr($LogTail, @LF & "Output written on") Then Halt(2)

; Warning ̃`FbN -------------------------------------------------------
$ExistWarning = False
If $Type = 1 AND $View <> 2 AND $Warning < 3 Then
  $n = 0
  While True
    $n = StringInStr($Log, "Warning: ", 1, 1, $n + 1)
    If $n = 0 Then ExitLoop
    If $Warning = 2 Then
      $ExistWarning = True
      ExitLoop
    EndIf
    If StringMid($Log, $n - 11, 11) <> "LaTeX Font " Then
      $ExistWarning = True
      ExitLoop
    EndIf
  WEnd
EndIf

; ʂ̕\ ---------------------------------------------------------------
Switch $Output
  Case 1 ; dvipdfm(x)  PDF ɕϊĕ\
    If $PdfLock = "Yes" Then WinClose($PdfViewerT, "")
    RunWait($ComSpec & "dvipdfmx" & $dvipdfmxOption & " " & $DviFile & $ConfirmStr, "", $Mode)
    ShowPDF()
  Case 2 ; PS 炳 PDF ɕϊĕ\
    If $PdfLock = "Yes" Then WinClose($PdfViewerT, "")
    If $TeXType = 1 Then
      $Bkmk = "bkmk2uni"
    Else
      $Bkmk = "convbkmk -u"
    EndIf
    RunWait($ComSpec & "dvips -Ppdf -f -z" & $dvipsOption & " " & $DviFile & " | " & $Bkmk & " >" & $PsFile & $ConfirmStr, "", $Mode)
    GetBoundingBox()
    RunWait($ComSpec & "gswin32c.exe -dCompatibilityLevel#1.4 -q -dSAFER -dNOPAUSE -dBATCH -sDEVICE#pdfwrite" & $gsOption & " -sOutputFile#" & $PdfFile & " -c .setpdfwrite" & $gsOption2 & " -f" & $PsFile, "", $Mode)
    ShowPDF()
  Case 3 ; PDF t@C𒼐ڕ\
    ShowPDF()
  Case 4 ; dviout ŕ\
    If $View = 1 Then
      WinClose($DviFile, "")
      Run($dviout & $dvioutOption & " " & $DviFile)
      If $SrcCommand Then
        Sleep($Delay3)
        _DDE_Execute("dviout", "dviout", $SrcCommand)
      EndIf
      If (NOT $MenuMode) AND $Active = 2 Then WinActivate($TeXFile, "")
    ElseIf NOT $ExistWarning Then
      MsgBox(0, "", "dvi t@C" & $Message[13], 1)
    EndIf
  Case 5 ; PS ɕϊ GSview ŕ\
    WinClose($PsFile, "")
    RunWait($ComSpec & "dvips" & $dvipsOption & " -z -o " & $PsFile & " " & $DviFile & $ConfirmStr, "", $Mode)
    If $CheckSize Then CheckSize()
    If $View = 1 Then
      If $USB Then
        IniWrite($gsviewIniFile, "UserMedia", "jisB4", "729,1032")
        IniWrite($gsviewIniFile, "UserMedia", "jisB5", "516,729")
        Run($gsview & " -a" & $gsviewOption & " " & $PsFile)
        If WinWaitActive("Select Lang", "", 500) Then Send("{ENTER}")
      Else
        Run($gsview & $gsviewOption & " " & $PsFile)
      EndIf
      If WinWaitActive("GSview Registration", "", 500) Then Send("{ENTER}")
      If FileExists($SyncFile) AND $LineNumber <> "" Then
        Sleep($Delay3)
        $Page = ViewerPage()
        _DDE_Execute("GSview", "GSview", "[GotoPage(" & $Page & ")]")
      EndIf
      If (NOT $MenuMode) AND $Active = 2 Then WinActivate($TeXFile, "")
    ElseIf NOT $ExistWarning Then
      MsgBox(0, "", "ps t@C" & $Message[13], 1)
    EndIf
EndSwitch

If $ExistWarning Then
  Sleep($Delay1)
  Halt(3)
EndIf

Exit

; ==========================================================================

; t@C݂邩ǂ -----------------------------------------------
Func CheckFileExists($F, $G)
  If $G = "" Then $G = $F
  If NOT FileExists($F) Then
    MsgBox(4096, "G[", $G & " " & $Message[14], 2)
    Exit
  EndIf
EndFunc

; tHg}bvt@C̐ݒ ---------------------------------------------
Func GetFontmap($s, $n)
  If $n = -1 Then
    Return "ߍ܂Ȃ"
  ElseIf $n = 0 OR $s = "" Then
    Return "ftHg"
  Else
    $s = "|" & $s & "|"
    $i = StringInStr($s, "|", 0, $n + 1)
    If $i = 0 Then Return "ftHg"
    $s = StringLeft($s, $i - 1)
    $i = StringInStr($s, "|", 0, -1)
    Return StringTrimLeft($s, $i)
  EndIf
EndFunc

; pftHg -------------------------------------------------------
Func ResetPaper()
  $Paper = 1
  $Orientation = 1
  $Width  = ""
  $Height = ""
EndFunc

; TeX ̃^Cv̐ -------------------------------------------------------
Func GuessTeXType($F, $t)
  $File = FileOpen($F, 0)
  $Lines = ""
  $Count = 30
  While $Count > 0
    $Lines &= $NL & FileReadLine($File)
    If @error = -1 Then ExitLoop
    $Count -= 1
  WEnd
  FileClose($File)
  $SetPaper = 1
  If StringRegExp($Lines, $NL & "[^%]*\\special[^%]*{[^%]*papersize") Then $SetPaper = 2
  $s = StringRegExp($Lines, $NL & " *\\documentclass(.*?})", 3)
  If $s <> $NoMatches Then
    $Type = 1
    $ClassStr = $s[0]
    $Paper = 1
    $Orientation = 1
    If StringInStr($ClassStr, "papersize", 1) Then $SetPaper = 2
    ; jsarticle, jsbook
    If $SetPaper = 1 Then
      $u = StringRegExp($ClassStr, "(a4|a5|a3|b4|b5)", 3)
      If $u <> $NoMatches Then
        $v = StringRegExp("A41A52A33B44B55", StringUpper($u[0]) & "(\d)", 3)
        If $v <> $NoMatches Then $Paper = $v[0]
      EndIf
      If StringInStr($ClassStr, "landscape", 1) Then $Orientation = 2
    EndIf
    If StringRegExp($ClassStr, "{(u[jt](article|report|book))}") OR StringRegExp($ClassStr, "uplatex") Then
      $TeXType = 2
    ElseIf StringRegExp($ClassStr, "{((j|js|t)(article|book)|[jt]report)}") OR StringRegExp($ClassStr, "platex") Then
      $TeXType = 1
    ElseIf StringRegExp($ClassStr, "{(ltjs?(article|book)|ltjreport)}") OR StringRegExp($Lines, $NL & "[^%]*\\usepackage{luatexja") Then
      If $TeXType <> 4 Then $TeXType = 3
    ElseIf StringRegExp($Lines, $NL & "[^%]*\\usepackage{luacode}") OR StringRegExp($Lines, $NL & "[^%]*\\directlua{") Then 
      If $TeXType <> 4 Then $TeXType = 3
    ElseIf StringRegExp($Lines, $NL & "[^%]*\\usepackage{zxjatype}") OR StringRegExp($Lines, $NL & "[^%]*\\usepackage.*{xeCJK}") OR StringRegExp($Lines, $NL & "[^%]*\\XeTeX") Then
      $TeXType = 5
    ElseIf StringRegExp($Lines, $NL & "[^%]*\\usepackage.*{bxcjkjatype}") OR StringRegExp($ClassStr, "CJK") Then
      $TeXType = 6
    ElseIf StringRegExp($ClassStr, "{(article|report|book)}") Then
      If $TeXType < 3 Then $TeXType = 6
    EndIf
  Else
    If $t AND ($Type = 1 OR $BaseFile <> $PrevBaseFile OR $WorkingDir <> $PrevDir) Then
      GetParent($Type)
    Else
      $Type = 2
    EndIf
  EndIf
EndFunc

; R[h̎擾 ---------------------------------------------------------
Func GuessEncoding()
  If NOT FileExists($TeXbin & "\nkf.exe") Then
    MsgBox(4096, "G[",  "ini t@C TeXbin " & $Message[6], 2)
    Exit
  EndIf
  RunWait($ComSpec & $TeXbin & "\nkf -g " & $WorkingDir & $TeXFile & ">@ENC@", "", @SW_HIDE)
  $File = FileOpen("@ENC@", 0)
  $s = StringTrimRight(FileRead($File), 1)
  FileClose($File)
  FileDelete ("@ENC@")
  Switch $s
    Case "CP932", "Shift_JIS"
      $Encoding = "sjis"
    Case "ISO-2022-JP"
      $Encoding = "jis"
    Case "EUC-JP"
      $Encoding = "euc"
    Case "UTF-8"
      $Encoding = "utf8"
    Case "ASCII"
      $Encoding = "ascii"
    Case Else
      MsgBox(4096, "G[", $Message[17])
      Exit
  EndSwitch
EndFunc

; et@C̎w ---------------------------------------------------------
Func GetParent($t)
  $Window = GUICreate("et@C̎w", 450, 240)
  $PrevParent = GUICtrlCreateButton("ȉet@C",  15, 20, 110)
  GuiCtrlCreateLabel("fBNg F " & $PrevDir, 15, 55)
  GuiCtrlCreateLabel("t@C@@ F " & $PrevBaseFile & ".tex", 15, 70)
  $ThisParent = GUICtrlCreateButton("̃t@Cet@C",  15, 105, 140)
  GuiCtrlCreateLabel("fBNg F " & $WorkingDir, 15, 140)
  GuiCtrlCreateLabel("t@C@@ F " & $BaseFile & ".tex", 15, 155)
  $NewParent  = GUICtrlCreateButton("Vɐet@Cw肷",  15, 190, 160)
  If $t = 1 Then
    Focus($PrevParent)
  Else
    Focus($ThisParent)
  EndIf
  GUISetState()
  $GetNewParent = False
  While True
    $Msg = GUIGetMsg()
    Switch $Msg
      Case $PrevParent
        $WorkingDir = $PrevDir
        $BaseFile = $PrevBaseFile
        $TeXFile  = $BaseFile & ".tex"
        $s = $WorkingDir & $TeXFile
        CheckFileExists($s, "et@C " & $s)
        $SameParent = True
        ExitLoop
      Case $ThisParent
        $Type = 2
        ResetPaper()
        ExitLoop
      Case $NewParent
        $GetNewParent = True
        ExitLoop
      Case $GUI_EVENT_CLOSE
        Exit
    EndSwitch
  WEnd
  GUIDelete($Window)
  If $GetNewParent Then
    $NewFile = FileOpenDialog ("et@Cw肷", $WorkingDir, "TeX files (*.tex)", 3)
    If @error Then Exit
    $s = StringRegExp($NewFile, "^(.*\\)(.*)$", 3)
    $WorkingDir = $s[0]
    $BaseFile = StringTrimRight($s[1], 4)
    $TeXFile  = $BaseFile & ".tex"
    ResetPaper()
    GuessTeXType($WorkingDir & $TeXFile, False)
  EndIf
EndFunc

; Cj[ -----------------------------------------------------------
Func ShowMenu()
  Global $AltOutput, $Ou, $Co, $Vi, $NA, $CP, $SE, $In, $St, $Bi, $Pa, $Or, $Wi, $He, $JF, $EF
  $Window = GUICreate($TeXFile, 430, 455)
  If $Type = 1 Then
    GuiCtrlCreateGroup("LaTeX", 10, 15, 200, 90)
    $Te = GuiCtrlCreateRadio("pLaTeX",       25, 35)             ; TeX
          GuiCtrlCreateRadio("upLaTeX",     110, 35)
          GuiCtrlCreateRadio("LuaLaTeX",     25, 55)
          GuiCtrlCreateRadio("LuaJITLaTeX", 110, 55)
          GuiCtrlCreateRadio("XeLaTeX",      25, 75)
          GuiCtrlCreateRadio("pdfLaTeX",    110, 75)
  Else
    GuiCtrlCreateGroup("TeX",   10, 15, 200, 90)
    $Te = GuiCtrlCreateRadio("e-pTeX",       25, 35)
          GuiCtrlCreateRadio("e-upTeX",     110, 35)
          GuiCtrlCreateRadio("LuaTeX",       25, 55)
          GuiCtrlCreateRadio("LuaJITTeX",   110, 55)
          GuiCtrlCreateRadio("XeTeX",        25, 75)
          GuiCtrlCreateRadio("pdfTeX",      110, 75)
  EndIf
  GuiCtrlCreateGroup("o̓t@C", 220, 15, 200, 90)
  $Ou = GuiCtrlCreateRadio("dvi  PDF", 235, 35)                ; Output
        GuiCtrlCreateRadio("ps  PDF",  325, 35)
        GuiCtrlCreateRadio("PDF",        235, 55)
        GuiCtrlCreateRadio("dvi",        235, 75)
        GuiCtrlCreateRadio("ps",         325, 75)
  GuiCtrlCreateGroup("ro", 10, 115, 200, 90)
  $Pr = GuiCtrlCreateRadio("\",     25, 135)          ; Process
        GuiCtrlCreateRadio("̂ݕ\", 25, 155)
        GuiCtrlCreateRadio("\Ȃ",       25, 175)
  $Co = GUICtrlCreateCheckbox("mF", 135, 135)              ; Confirm
  If $Type = 1 Then
    GuiCtrlCreateGroup("o̓t@C̕\", 220, 115, 200, 90)
    $Vi = GuiCtrlCreateRadio("\", 235, 135)               ; View
          GuiCtrlCreateRadio("\Ȃ iTeX N 1 j",  235, 155)
          GuiCtrlCreateRadio("\Ȃ iTeX Nj", 235, 175)
    $ViewNum = 3
  Else
    GuiCtrlCreateGroup("o̓t@C̕\", 220, 115, 200, 70)
    $Vi = GuiCtrlCreateRadio("\",   235, 135)
          GuiCtrlCreateRadio("\Ȃ", 235, 155)
    $ViewNum = 2
  EndIf
  $NA = GUICtrlCreateCheckbox("ANeBu", 320, 135)        ; Non Active
  If $Type = 1 Then
    GuiCtrlCreateGroup("Warning", 10, 215, 200, 90)              ; Warning
    $Wa = GuiCtrlCreateRadio("Font Warning ȊO`FbN", 25, 235)
          GuiCtrlCreateRadio("ׂă`FbN",              25, 255)
          GuiCtrlCreateRadio("",                        25, 275)
    GuiCtrlCreateLabel("IvV", 225, 235)
    $In = GuiCtrlCreateInput("", 240, 255, 175)                  ; Index
  Else
    GuiCtrlCreateGroup("p", 10, 215, 200, 90)
    $Pa = GuiCtrlCreateRadio("A4",      25, 235)                 ; Paper
          GuiCtrlCreateRadio("A5",      90, 235)
          GuiCtrlCreateRadio("A3",     155, 235)
          GuiCtrlCreateRadio("B4J",     25, 255)
          GuiCtrlCreateRadio("B5J",     90, 255)
          GuiCtrlCreateRadio("͂",  25, 275)
          GuiCtrlCreateRadio("Free",    90, 275)
    GuiCtrlCreateGroup("p̌", 220, 215, 200, 50)
    $Or = GuiCtrlCreateRadio("cu", 235, 235)                 ; Orientation
          GuiCtrlCreateRadio("u", 325, 235)
    GuiCtrlCreateLabel("", 235, 284)
    $Wi = GuiCtrlCreateInput("",  255, 280, 35)                  ; Width
    GuiCtrlCreateLabel("~", 295, 284)
    GuiCtrlCreateLabel("c", 330, 284)
    $He = GuiCtrlCreateInput("", 350, 280, 35)                   ; Height
    GuiCtrlCreateLabel("~", 390, 284)
  EndIf
  GuiCtrlCreateGroup("tHg", 10, 315, 200, 80)
  GuiCtrlCreateLabel("a i.mapj", 25, 341)
  $JF = GUICtrlCreateCombo("", 95, 337, 100)
  $EF = GUICtrlCreateCheckbox("{" & $EFontStr & "͖̂ߍ܂Ȃ", 25, 366)
  $CP = GUICtrlCreateCheckbox("pݒ HappyTeX ɂ܂Ȃ", 225, 320)
  ; CheckPaper
  $SE = GUICtrlCreateCheckbox("TeX  shell-escape Lɂ", 225, 343)
  ; ShellEscape
  $Remark   = GUICtrlCreateButton("Remark",             240, 383,  60, 21)
  $Ini      = GUICtrlCreateButton("ini t@C̕\", 315, 383, 100, 21)
  $About    = GUICtrlCreateButton("About",              180, 415,  60, 21)
  $Execute  = GUICtrlCreateButton("s",               255, 415,  60, 21)
  $SaveOnly = GUICtrlCreateButton("ݒ̕ۑ",         330, 415,  85, 21)
  $AltOutput = $Output
  If $AltOutput = 3 Then $AltOutput = 1
  If $Type = 2 AND $View = 3 Then $View = 2
  Check($Te + $TeXType - 1)
  SetOutput($AltOutput)
  SetConfirm()
  SetFontmap()
  Check($Vi + $View - 1)
  SetView()
  Check($Pr + $Process - 1)
  If $Confirm = 2 Then GUICtrlSetState($Co, $GUI_CHECKED)
  If $Process = 3 Then Hide("Confirm")
  If $Active = 2 Then GUICtrlSetState($NA, $GUI_CHECKED)
  If $Type = 1 Then
    Check($Wa + $Warning - 1)
    SetIndex()
  Else
    Check($Pa + $Paper - 1)
    Check($Or + $Orientation - 1)
    If $Paper < 7 Then
      WritePaperSize()
    Else
      Hide("Orientation")
      GUICtrlSetData($Wi, $Width)
      GUICtrlSetData($He, $Height)
    EndIf
    If $Output = 3 OR ($Output = 4 AND $View > 1) Then
      HidePaperGroup()
    EndIf
  EndIf
  If $EFont = 2 Then GUICtrlSetState($EF, $GUI_CHECKED)
  If $CheckPaper = 2 Then GUICtrlSetState($CP, $GUI_CHECKED)
  If $ShellEscape = 2 Then GUICtrlSetState($SE, $GUI_CHECKED)
  Focus($Execute)
  GUISetState()
  $WindowHandle = ControlGetHandle("[ACTIVE]", "", "")
  While True
    $Msg = GUIGetMsg()
    Switch $Msg
      Case $Te To $Te + 5
        $TeXType = $Msg - $Te + 1
        ReadFontmap()
        SetOutput($AltOutput)
        SetConfirm()
        SetFontmap()
        SetView()
        If $Type = 1 Then SetIndex()
      Case $Ou To $Ou + 4
        ReadFontmap()
        $Output = $Msg - $Ou + 1
        If $Output <> 3 Then $AltOutput = $Output
        SetConfirm()
        SetFontmap()
        SetView()
      Case $Pr To $Pr + 2
        $Process = $Msg - $Pr + 1
        SetConfirm()
      Case $Vi To $Vi + $ViewNum - 1
        $View = $Msg - $Vi + 1
        If $View = 1 Then
          Show("Active")
        Else
          Hide("Active")
        EndIf
        If $Output = 4 AND $View > 1 Then
          Hide("CheckPaper")
          If $Type = 2 Then HidePaperGroup()
        Else
          Show("CheckPaper")
          If $Type = 2 Then
            If $CheckPaper = 1 Then
              ShowPaperGroup()
            Else
              HidePaperGroup()
            EndIf
          EndIf
        EndIf
      Case $CP
        $CheckPaper = 3 - $CheckPaper
        If $Type = 2 Then
          If $CheckPaper = 1 AND $Output <> 3 AND ($Output <> 4 OR $View = 1) Then
            ShowPaperGroup()
          Else
            HidePaperGroup()
          EndIf
        EndIf
      Case $Remark
        ShowRemark($WindowHandle)
      Case $Ini
        Run($Editor & " " & $IniFile)
        Exit
      Case $About
        ShowAbout($WindowHandle)
      Case $GUI_EVENT_CLOSE
        Exit
      Case $Execute, $SaveOnly
        If $Type = 2 AND  $Output <> 3 AND ($Output <> 4 OR $View = 1) AND $Paper = 7 AND ($Width = "" OR $Height = "") Then
          MsgBox(0, "", "pTCY" & $Message[15], 1)
          Focus($Wi)
          ContinueLoop
        EndIf
        ExitLoop
      Case Else
        If $Type = 1 Then
          Switch $Msg
            Case $Wa To $Wa + 2
              $Warning = $Msg - $Wa + 1
            Case $In
              If $TeXType = 1 Then
                $MendexOpt = GUICtrlRead($In)
              ElseIf $TeXType > 2 Then
                $MakeIndexOpt = GUICtrlRead($In)
              EndIf
          EndSwitch
        Else
          Switch $Msg
            Case $Pa To $Pa + 7
              $Paper = $Msg - $Pa + 1
              If $Paper < 7 Then
                WritePaperSize()
              Else
                Hide("Orientation")
                Show("SizeAll")
                GUICtrlSetData($Wi, $Width)
                GUICtrlSetData($He, $Height)
                Focus($Wi)
              EndIf
            Case $Or To $Or + 1
              $PrevOrientation = $Orientation
              $Orientation = $Msg - $Or + 1
              If $Orientation <> $PrevOrientation Then
                $temp = GUICtrlRead($Wi)
                GUICtrlSetData($Wi, GUICtrlRead($He))
                GUICtrlSetData($He, $temp)
              EndIf
            Case $Wi
              $temp = GUICtrlRead($Wi)
              If $temp = "" OR (StringIsInt($temp) AND ($temp > 0)) Then $Width = $temp
              GUICtrlSetData($Wi, $Width)
            Case $He
              $temp = GUICtrlRead($He)
              If $temp = "" OR (StringIsInt($temp) AND ($temp > 0)) Then $Height = $temp
          EndSwitch
        EndIf
    EndSwitch
  WEnd
  If $TeXType > 1 AND $TeXType < 6 AND $Encoding <> "utf8" AND $Encoding <> "ascii" Then
    GUIDelete($Window)
    MsgBox(4096, "G[", "R[h UTF-8 " & $Message[18])
    Exit
  EndIf
  SaveIniFile()
  GUIDelete($Window)
  If $Msg = $SaveOnly Then
    MsgBox(0, "", $Message[16], 1)
    Exit
  EndIf
EndFunc

Func SetOutput($s)
  If $TeXType < 3 Then
    $Output = $s
    Check($Ou + $Output - 1)
    Show("NotPDFOnly")
  Else
    $Output = 3
    Check($Ou + 2)
    Show("PDFOnly")
  EndIf
EndFunc

Func SetConfirm()
  If ($Output < 3 OR $Output = 5) AND $Process < 3 Then
    Show("Confirm")
  Else
    Hide("Confirm")
  EndIf
EndFunc

Func SetFontmap()
  GUICtrlSetData($JF, "", "")
  If $Output < 3 OR $Output = 5 Then
    If $Output = 1 Then
      $s = $FontmapList
      $t = $Fontmap
    Else
      $s = $psFontmapList
      $t = $psFontmap
    EndIf
    If $s <> "" Then $s &= "|"
    GUICtrlSetData($JF, "ftHg|" & $s & "ߍ܂Ȃ", $t)
    Show("Fontmap")
  Else
    Hide("Fontmap")
  EndIf
EndFunc

Func ReadFontmap()
  If $Output = 1 Then
    $Fontmap = GUICtrlRead($JF)
    $FontmapList = RenewList($FontmapList, $Fontmap)
  ElseIf $Output = 2 OR $Output = 5 Then
    $psFontmap = GUICtrlRead($JF)
    $psFontmapList = RenewList($psFontmapList, $psFontmap)
  EndIf
EndFunc

Func RenewList($s, $t)
  If $t <> "" Then
    $u = $s
    If $u <> "" Then $u &= "|"
    If StringInStr("|ߍ܂Ȃ|ftHg|" & $u, "|" & $t & "|") = 0 Then
      $s = $u & $t
      $n = StringInStr($s, "|", 0, $MaxListNum)
      If $n > 0 Then
        $m = StringInStr($s, "|")
        $s = StringTrimLeft($s, $m)
      EndIf
    EndIf
  EndIf
  Return $s
EndFunc

Func SetView()
  If $NotUseDviout AND $Output = 4 Then
    If $View = 1 Then
      $View = 2
      Check($Vi + 1)
    EndIf
    Hide("View")
    Hide("Active")
  Else
    Show("View")
    If $View = 1 Then
      Show("Active")
    Else
      Hide("Active")
    EndIf
  EndIf
  If $Output = 3 OR ($Output = 4 AND $View > 1) Then
    Hide("CheckPaper")
    If $Type = 2 Then HidePaperGroup()
  Else
    Show("CheckPaper")
    If $Type = 2 Then
      If $CheckPaper = 1 Then
        ShowPaperGroup()
      Else
        HidePaperGroup()
      EndIf
    EndIf
  EndIf
EndFunc

Func SetIndex()
  Show("Index")
  If $TeXType < 3 Then
    GuiCtrlCreateLabel("imendexj   ", 270, 235)
    GUICtrlSetData($In, $MendexOpt)
  Else
    GuiCtrlCreateLabel("imakeindexj", 270, 235)
    GUICtrlSetData($In, $MakeIndexOpt)
  EndIf
  If $TeXType = 2 Then Hide("Index")
EndFunc

Func WritePaperSize()
  $x = $WidthList[$Paper - 1]
  $y = $HeightList[$Paper -1]
  If $Orientation = 1 Then
    GUICtrlSetData($Wi, $x)
    GUICtrlSetData($He, $y)
  Else
    GUICtrlSetData($Wi, $y)
    GUICtrlSetData($He, $x)
  EndIf
  Show("Orientation")
  Show("SizeAll")
  Hide("Size")
EndFunc

; j[֘A -------------------------------------------------------------
Func Check($x)
  GUICtrlSetState($x, $GUI_CHECKED)
EndFunc

Func Focus($x)
  GUICtrlSetState($x, $GUI_FOCUS)
EndFunc

Func Show($x)
  Switch $x
    Case "PDFOnly"
      HideMain($Ou, 1)
      ShowMain($Ou + 2, 0)
      HideMain($Ou + 3, 1)
    Case "NotPDFOnly"
      ShowMain($Ou, 1)
      HideMain($Ou + 2, 0)
      ShowMain($Ou + 3, 1)
    Case "Confirm"
      ShowMain($Co, 0)
    Case "View"
      ShowMain($Vi, 0)
    Case "Active"
      ShowMain($NA, 0)
    Case "Index"
      ShowMain($In, 0)
    Case "Paper"
      ShowMain($Pa, 6)
    Case "Orientation"
      ShowMain($Or, 1)
    Case "SizeAll"
      ShowMain($Wi - 1, 5)
    Case "Size"
      ShowMain($Wi, 0)
      ShowMain($He, 0)
    Case "Fontmap"
      ShowMain($JF - 1, 2)
    Case "CheckPaper"
      ShowMain($CP, 0)
  EndSwitch
EndFunc

Func ShowMain($x, $y)
  For $i = 0 To $y
    GUICtrlSetState($x + $i, $GUI_ENABLE)
  Next
EndFunc

Func Hide($x)
  Switch $x
    Case "Confirm"
      HideMain($Co, 0)
    Case "View"
      HideMain($Vi, 0)
    Case "Active"
      HideMain($NA, 0)
    Case "Index"
      HideMain($In, 0)
    Case "Paper"
      HideMain($Pa, 6)
    Case "Orientation"
      HideMain($Or, 1)
    Case "SizeAll"
      HideMain($Wi - 1, 5)
    Case "Size"
      HideMain($Wi, 0)
      HideMain($He, 0)
    Case "Fontmap"
      HideMain($JF - 1, 2)
    Case "CheckPaper"
      HideMain($CP, 0)
  EndSwitch
EndFunc

Func HideMain($x, $y)
  For $i = 0 To $y
    GUICtrlSetState($x + $i, $GUI_DISABLE)
  Next
EndFunc

Func ShowPaperGroup()
  Show("Paper")
  If $Paper < 7 Then
    Show("Orientation")
    Show("SizeAll")
    Hide("Size")
  Else
    Hide("Orientation")
    Show("SizeAll")
  EndIf
EndFunc

Func HidePaperGroup()
  Hide("Paper")
  Hide("Orientation")
  Hide("SizeAll")
EndFunc

; Remark -------------------------------------------------------------------
Func ShowRemark($Handle)
  MsgBox(0, "Remark", " upLaTeX, e-upTeX, Lua(JIT)(La)TeX, Xe(La)TeX" & $NL2 & _
$LeftSpace & "t@Cɓ{gȂłD" & $NL2 & _
$LeftSpace & "܂R[h UTF-8 ɂĂD" & $NL2 & _
" pdf(La)TeX" & $NL2 & _
$LeftSpace & "{IɉpłD" & $NL2 & _
$LeftSpace & " CJK pbP[Wgē{邱Ƃ͉\łD" & $NL2 & _
" sR[h" & $NL2 & _
$LeftSpace & "CR{LFCCRCLF ̂ǂłvłD" & $NL2 & _
" ro߂́umFv" & $NL2 & _
$LeftSpace & "ro߂\悤ɂĂCɃ`FbN" & $NL2 & _
$LeftSpace & "dvipdfmx  dvips ł̃G[xbZ[WmFł܂D" & $NL2 & _
$LeftSpace & "dvi t@C쐬Ⓖڂ PDF t@C쐬̃G[x" & $NL2 & _
$LeftSpace & "bZ[W log t@CĂD" & $NL2 & _
" tHg" & $NL2 & _
$LeftSpace & "a --- gp map t@Cw肵܂D" & $NL2 & _
$LeftSpace & " --- ini t@C 14C12C6 ƕ\ς܂D" & $NL2 & _
" IvV" & $NL2 & _
$LeftSpace & "mendex / makeindex ̃IvVłD" & $NL2 & _
$LeftSpace & "KvȂ珑t@C -s myindex ̂悤Ɏw肵ĂD" & $NL2 & $NL & _
" (u)(p)BibTeX" & $NL2 & _
$LeftSpace & "Nꍇ͕Kj[ʂĂD" & $NL2 & _
$LeftSpace & "j[ʂȂꍇ͋N܂D" & $NL2 & _
" PDF t@ĈE^Cg̓{" & $NL2 & _
$LeftSpace & "hyperref pbP[WĝȒPłD" & $NL2 & _
$LeftSpace & "dvipdfmx  PDF t@C쐬ꍇC" & $NL2 & _
$LeftSpace & " pxjahyper pbP[Wǂݍނƕh܂D" & $NL2 & _
$LeftSpace & "dvips oR PDF t@C쐬ꍇ͉ȂđvłD" & $NL2 & _
$LeftSpace & "̃XNvg pLaTeX ̏ꍇ bkmk2uni.exe C" & $NL2 & _
$LeftSpace & "upLaTeX ̏ꍇ convbkmk.rb s邩łD" & $NL2 & _
" pdf(La)TeX  dvi o" & $NL2 & _
$LeftSpace & "̃XNvgł pdf(La)TeX  dvi o͂ɂ͑ΉĂ܂D" & $NL2 & _
$LeftSpace & "e \pdfoutput=0 ܂ȂłD", 0, $Handle)
EndFunc

; About --------------------------------------------------------------------
Func ShowAbout($Handle)
  $Website = "http://www.u-gakugei.ac.jp/~takizawa/Happy/"
  $AboutWindow = GUICreate("About", 225, 130, -1, -1, BitOr($WS_CAPTION, $WS_SYSMENU), -1, $Handle)
  GuiCtrlCreateLabel("TeX ^CvZbgvr[xXNvg", 15, 10)
  GuiCtrlCreateLabel("HappyTeX  Ver " & $Version & "  " & $Date, 15, 35)
  GuiCtrlCreateLabel("by  ", 15, 60)
  $URL = GUICtrlCreateButton("Web TCg", 110, 57, 100, 21)
  $OK = GUICtrlCreateButton("OK", 67, 100, 91, 21)
  Focus($OK)
  GUISetState()
  While True
    $Msg = GUIGetMsg()
    Switch $Msg
      Case $URL
        ShellExecute($Website, "", "", "open")
        Exit
      Case $GUI_EVENT_CLOSE, $OK
        ExitLoop
    EndSwitch
  WEnd
  GUIDelete($AboutWindow)
EndFunc

; ݒ ini t@Cɏ --------------------------------------------
Func SaveIniFile()
  IniWrite($IniFile, "Typeset", "Type",    $Type)
  IniWrite($IniFile, "Typeset", "TeX",     $TeXType)
  IniWrite($IniFile, "Typeset", "Output",  $Output)
  IniWrite($IniFile, "Typeset", "Process", $Process)
  If $Process < 3 Then
    IniWrite($IniFile, "Typeset", "ShowProcess", 1)
  Else
    IniWrite($IniFile, "Typeset", "ShowProcess", 2)
  EndIf
  If GUICtrlRead($Co) = $GUI_CHECKED Then
    $Confirm = 2
  Else
    $Confirm = 1
  EndIf
  IniWrite($IniFile, "Typeset", "Confirm", $Confirm)
  IniWrite($IniFile, "Typeset", "View",    $View)
  If GUICtrlRead($NA) = $GUI_CHECKED Then
    $Active = 2
  Else
    $Active = 1
  EndIf
  IniWrite($IniFile, "Typeset", "Active", $Active)
  ReadFontmap()
  If $Output < 3 OR $Output = 5 Then
    If GUICtrlRead($EF) = $GUI_CHECKED Then
      $EFont = 2
    Else
      $EFont = 1
    EndIf
    IniWrite($IniFile, "Font", "EFont", $EFont)
    If $Output = 1 Then
      $FontmapNum = GetListNum($FontmapList, $Fontmap)
      IniWrite($IniFile, "Font", "FontmapList", $FontmapList)
      IniWrite($IniFile, "Font", "FontmapNum",  $FontmapNum)
    Else
      $psFontmapNum = GetListNum($psFontmapList, $psFontmap)
      IniWrite($IniFile, "Font", "psFontmapList", $psFontmapList)
      IniWrite($IniFile, "Font", "psFontmapNum",  $psFontmapNum)
    EndIf
  EndIf
  IniWrite($IniFile, "Typeset", "CheckPaper", $CheckPaper)
  If $CheckPaper = 2 Then $SetPaper = 2
  IniWrite($IniFile, "Typeset", "SetPaper",   $SetPaper)
  If GUICtrlRead($SE) = $GUI_CHECKED Then
    $ShellEscape = 2
  Else
    $ShellEscape = 1
  EndIf
  IniWrite($IniFile, "Typeset", "ShellEscape", $ShellEscape)
  IniWrite($IniFile, "Typeset", "Encoding",    $Encoding)
  If $Type = 1 Then
    IniWrite($IniFile, "Typeset", "Warning", $Warning)
    If $TeXType = 1 Then
      IniWrite($IniFile, "Option", "mendex",    $MendexOpt)
    ElseIf $TeXType > 2 Then
      IniWrite($IniFile, "Option", "makeindex", $MakeIndexOpt)
    EndIf
    IniWrite($IniFile, "Paper",  "Size", $Paper)
    IniWrite($IniFile, "Paper",  "Orientation", $Orientation)
  ElseIf $Output <> 3 AND ($Output <> 4 OR $View = 1) Then
    IniWrite($IniFile, "Paper",   "Size",   $Paper)
    If $Paper < 7 Then
      IniWrite($IniFile, "Paper", "Orientation", $Orientation)
    Else
      IniWrite($IniFile, "Paper", "Width",  $Width)
      IniWrite($IniFile, "Paper", "Height", $Height)
    EndIf
  EndIf
  IniWrite($IniFile, "MainFile", "Base",      $BaseFile)
  IniWrite($IniFile, "MainFile", "Directory", $WorkingDir)
EndFunc

Func GetListNum($s, $t)
  If $t = "" Then $t = "ftHg"
  $u = StringSplit("ߍ܂Ȃ|ftHg|" & $s, "|")
  $n = 0
  While $n < $u[0]
    $n += 1
    If $u[$n] = $t Then ExitLoop
  WEnd
  Return $n - 2
EndFunc

; y[Wԍ̎擾 ---------------------------------------------------------
Func ViewerPage()
  $File = FileOpen($SyncFile, 0)
  $Data = FileRead($File)
  FileClose($File)
  If $TeXFile = $StartFile Then
    $InputNo = 1
  Else
    $InputNo = 0
    $StartFile = StringReplace($StartFile, ".", "\.")
    While True
      $n = StringInStr($Data, @LF & "Input:")
      If $n = 0 Then ExitLoop
      $Data = StringTrimLeft($Data, $n + 6)
      $Result = StringRegExp($Data, "^(\d+):" & $StartFile & "\n", 3)
      If $Result <> $NoMatches Then
        $InputNo = $Result[0]
        ExitLoop
      EndIf
    WEnd
    If $InputNo = 0 Then Return 1
  EndIf
  $P = 1
  While True
    $n = StringInStr($Data, @LF & "}")
    If $n = 0 Then ExitLoop
    $s = StringLeft($Data, $n - 1)
    $Data = StringTrimLeft($Data, $n + 1)
    $n = StringInStr($s, @LF & "h" & $InputNo & ",", 0, -1)
    If $n = 0 Then ContinueLoop
    $s = StringTrimLeft($s, $n + StringLen($InputNo) + 2)
    $n = StringInStr($s, ":")
    $m = Int(StringLeft($s, $n - 1))
    $n = StringInStr($s, "]")
    $s = StringLeft($s, $n - 1)
    Do
      $m += 1
    Until NOT StringInStr($s, @LF & "x" & $InputNo & "," & $m)
    $LastLine = $m - 1
    $n = StringInStr($Data, @LF)
    $P = StringLeft($Data, $n - 1)
    If $LineNumber <= $LastLine Then ExitLoop
  WEnd
  Return $P
EndFunc

; DDE ʐM -----------------------------------------------------------------
; ȉKvB
;   DDEML.au3ADDEMLClient.au3ADDEMLConstants.au3
; ADDEMLConstants.au3  DDEML.au3 IɃCN[hB
; DDEMLClient.au3 Œ`Ă _DDEMLClient_Execute ֐܂삵
; 悤Ȃ̂ŁAȉ̂悤ɏCB
Func _DDE_Execute($S, $T, $C) ; $S T[rXA$T gsbNA$C R}h
  _DdeInitialize("OnDDE_", 0)
  $Serv = _DdeCreateStringHandle($S)
  $Topi = _DdeCreateStringHandle($T)
  $Conn = _DdeConnect($Serv, $Topi)
  $Comm = _DdeCreateDataHandle($C)
  _DdeClientTransaction(0x4050, $Conn, $Comm)
  _DdeDisconnect($Conn)
  _DdeFreeStringHandle($Serv)
  _DdeFreeStringHandle($Topi)
  _DdeUninitialize()
EndFunc

; pTCYIvV̐ݒ -----------------------------------------------
Func SetPapersizeOption()
  $Paper = $PaperType[$Paper - 1]
  If $Output = 4 Then
    If $Paper = "Free" Then
      $dvioutOption = " -y:F" & $Width & "mm:" & $Height & "mm"
    Else
      $dvioutOption = " -y:" & $Paper
      If $Orientation = 2 Then $dvioutOption &= "L"
    EndIf
  Else
    $gsviewOption = " -oauto"
    $Paper = StringLower($Paper)
    If $Paper = "h" Then
      $Paper = "free"
      If $Orientation = 1 Then
        $Width  = "100"
        $Height = "148"
      Else
        $Width  = "148"
        $Height = "100"
      EndIf
    ElseIf StringLeft($Paper, 1) = "b" Then
      $Paper = "jis" & $Paper
    EndIf
    If $Paper = "free" Then
      $CheckSize = True
      $dvipdfmxOption = " -p " & $Width & "mm," & $Height & "mm"
      $dvipsOption = " -T " & $Width & "mm," & $Height & "mm"
    Else
      $CheckSize = False
      $dvipdfmxOption = " -p " & $Paper
      $dvipsOption = " -t " & $Paper
      If $Orientation = 2 Then
        $dvipdfmxOption &= " -l"
        $dvipsOption &= " -t landscape"
        $gsviewOption = " -oseascape"
      EndIf
    EndIf
  EndIf
EndFunc

; tHg̐ݒ -----------------------------------------------------------
Func SetFont()
  If $Output = 1 Then
    If $EFont = 1 Then
      $dvipdfmxOption &= " -f dlbase14.map"
    ElseIf $EFontType = 2 Then
      $dvipdfmxOption &= " -f dlbase2.map"
    ElseIf $EFontType = 3 Then
      $dvipdfmxOption &= " -f dlbase8.map"
    EndIf
    If $Fontmap = "ߍ܂Ȃ" Then
      If $NoEmbedType = 1 Then
        $Fontmap = "No-Embed"
      Else
        $Fontmap = "No-Embed04"
      EndIf
    EndIf
    If $Fontmap <> "" AND $Fontmap <> "ftHg" Then $dvipdfmxOption &= " -f " & $Fontmap & ".map"
  Else
    If $EFont = 1 Then
      $dvipsOption &= " -Pdl"
      If $psFontmap = "ߍ܂Ȃ" Then $gsOption2 = " -f neverembedJ.ps"
    Else
      If $EFontType = 1 Then
        $dvipsOption &= " -Ppdf"
        If $psFontmap = "ߍ܂Ȃ" Then
          $gsOption2 = " -f neverembedEJ.ps"
        Else
          $gsOption2 = " -f neverembedE.ps"
        EndIf
      ElseIf $EFontType = 2 Then
        $dvipsOption &= " -PpdfA"
        If $psFontmap = "ߍ܂Ȃ" Then
          $gsOption2 = " -f neverembedAJ.ps"
        Else
          $gsOption2 = " -f neverembedA.ps"
        EndIf
      Else
        $dvipsOption &= " -Pdl"
        If $psFontmap = "ߍ܂Ȃ" Then
          $gsOption2 = " -f neverembedBJ.ps"
        Else
          $gsOption2 = " -f neverembedB.ps"
        EndIf
      EndIf
    EndIf
    If $psFontmap = "ߍ܂Ȃ" Then $psFontmap = "MS-ps"
    If $psFontmap <> "" AND $psFontmap <> "ftHg" Then $dvipsOption &= " -u+" & $psFontmap & ".map"
  EndIf
EndFunc

; User Defined TCY̏ --------------------------------------------
Func CheckSize()
  $File = FileOpen($PsFile, 0)
  $s = ""
  $t = "-"
  $Count = 30
  While $Count > 0
    $Line = FileReadLine($File)
    If @error = -1 Then ExitLoop
    If $Line = "%%Orientation: Landscape" Then
      $gsviewOption = " -oseascape"
    ElseIf StringLeft($Line, 19) = "%%BoundingBox: 0 0 " Then
      $s = StringTrimLeft($Line, 19)
    ElseIf StringLeft($Line, 22) = "%%DocumentPaperSizes: " Then
      $t = StringTrimLeft($Line, 22)
    ElseIf $Line = "%%EndComments" Then
      ExitLoop
    EndIf
    $Count -= 1
  WEnd
  FileClose($File)
  If $s <> "" AND (NOT StringInStr("a4,a5,a3,jisb4,jisb5,b4,b5,ledger,legal,letter,note,a0,a1,a2", $t, 1)) Then
    IniWrite($gsviewIniFile, "Options", "Media", "User Defined")
    IniWrite($gsviewIniFile, "Options", "UserSize", $s)
  EndIf
EndFunc

; BoundingBox ̎擾 -------------------------------------------------------
Func GetBoundingBox()
  $File = FileOpen($PsFile, 0)
  $Lines = ""
  $Count = 30
  While $Count > 0
    $Lines &= $NL & FileReadLine($File)
    If @error = -1 Then ExitLoop
    $Count -= 1
  WEnd
  FileClose($File)
  $xy = StringRegExp($Lines, $NL & "%%BoundingBox: 0 0 (\d+) (\d+)", 3)
  If $xy <> $NoMatches Then $gsOption = " -dDEVICEWIDTHPOINTS#" & $xy[0] & " -dDEVICEHEIGHTPOINTS#" & $xy[1]
EndFunc

; PDF t@C̕\ -------------------------------------------------------
Func ShowPDF()
  If $View = 1 Then
    $SetDelay = False
    If $Synchro AND FileExists($SyncFile) AND $LineNumber <> "" Then
      If $PdfJumpType = "ddesynctex" Then
        $PdfOpen = StringReplace($PdfOpen, "%f", $FullPdfFile)
      Else
        $PdfOpen = SetPDFCommand($PdfOpen)
      EndIf
      If StringLeft($PdfJumpType, 3) = "dde" Then
        Run($PdfViewer & " " & $PdfOpen)
        Sleep($Delay3)
        If $PdfJumpType = "dde" Then
          $PdfJump = SetPDFCommand($PdfJump)
        EndIf
        _DDE_Execute($Service, $Topic, $PdfJump)
      Else
        Run($PdfViewer & " " & $PdfOpen)
        $SetDelay = True
      EndIf
    Else
      Run($PdfViewer & " " & $FullPdfFile)
      $SetDelay = True
    EndIf
    If $Active = 2 Then
      If $SetDelay Then Sleep($Delay3)
      WinActivate($TeXFile, "")
    EndIf
  ElseIf NOT $ExistWarning Then
    MsgBox(0, "", "PDF t@C" & $Message[13], 1)
  EndIf
EndFunc

; PDF t@CJIvV̐ݒ ---------------------------------------
Func SetPDFCommand($s)
  $Page = ViewerPage()
  $PageMinusOne = $Page - 1
  $s = StringReplace($s, "%p", $Page)
  $s = StringReplace($s, "%q", $PageMinusOne)
  $s = StringReplace($s, "%f", $FullPdfFile)
  Return $s
EndFunc

; bZ[W̐ݒ ---------------------------------------------------------
Func SetMessage($F)
  If $F = "" Then
    Dim $Message[$MessageNum] = ["f܂D", "񂩏܂CݎQƂf܂D", "͍쐬ł܂łD", "oĂ܂D", "\܂D", "w肵ĂD", "̎w肪܂D", "sĂ܂D", "΂炭҂D", "쐬܂͍XV܂H", "Ɍ肪悤łD", "͑܂C", "ĂD", "쐬ł܂D", "܂D", "͂łD", "ݒۑ܂D", "łȂR[hɂȂĂ܂D", "ɂĂD"]
    Dim $TranslationMessage[$TranslationMessageNum] = ["̃Rg[V[PX͒`Ă܂D", "iIĂ܂C܂D", "t@CIĂ܂C܂D", "̃Rg[V[PXŎgĂ͂܂D", "`ɍ܂D", "܂D", "$ KvłD", "ʂKvłD", "ʂ]łD", "ʂ]łD", "Pʂ܂D", "t@C܂D", "ł͖̏kxO[͎g܂D", "\begin  \end ̑ΉłD", "̃Rg[V[PX̓vAułg܂D", "LvV̊Oɂ܂D", "t@C܂D", "gȂ܂D", "\begin{document} ܂D", "̃JE^͒`Ă܂D", "̃IvV͎g܂D"]
  Else
    $File = FileOpen($F, 0)
    $s = FileRead($File)
    FileClose($File)
    $t = StringRegExp($s, "(?s)\[Basic\](\r\n)+(.*?)(\r\n)+\[Error\](\r\n)+(.*?)(\r\n)*$", 3)
    If $t <> $NoMatches Then
      $u = StringSplit($t[1], @CRLF, 1)
      If $u[0] <> $MessageNum Then Return
      For $i = 1 To $MessageNum
        If $u[$i] = "" Then Return
        $Message[$i - 1] = $u[$i]
      Next
      $u = StringSplit($t[4], @CRLF, 1)
      If $u[0] <> $TranslationMessageNum Then Return
      For $i = 1 To $TranslationMessageNum
        If $u[$i] = "" Then Return
        $TranslationMessage[$i - 1] = $u[$i]
      Next
      $NotSet = False
    EndIf
  EndIf
EndFunc

; f ---------------------------------------------------------------------
Func Halt($n)
  WinClose($LogFile, "")
  $Result = MsgBox(49, "Info", $Message[$n], $Delay2)
  If $Result <> 2 Then Run($Editor & " " & $LogFile) ; 2 : Cancel
  Exit
EndFunc

; ȃG[bZ[W̓{ -------------------------------------------
Func Translate($s)
  $t = -1
  ; TeX ̃G[bZ[W
  If StringLeft($s, 11) = "! Undefined" Then
    $t = 0
  ElseIf StringLeft($s, 11) = "! Paragraph" Then
    $t = 1
  ElseIf StringLeft($s, 18) = "! File ended while" Then
    $t = 2
  ElseIf StringLeft($s, 11) = "! Forbidden" Then
    $t = 3
  ElseIf StringLeft($s, 8) = "! Use of" Then
    $t = 4
  ElseIf StringLeft($s, 10) = "! Argument" Then
    $t = 5
  ElseIf StringLeft($s, 20) = "! Missing $ inserted" Then
    $t = 6
  ElseIf StringLeft($s, 11) = "! Missing }" Then
    $t = 7
  ElseIf StringLeft($s, 10) = "! Too many" Then
    $t = 8
  ElseIf StringLeft($s, 9) = "! Extra }" Then
    $t = 9
  ElseIf StringLeft($s, 14) = "! Illegal unit" Then
    $t = 10
  ElseIf StringLeft($s, 14) = "! I can't find" Then
    $t = 11
  ElseIf StringLeft($s, 10) = "! Infinite" Then
    $t = 12
  ; LaTeX ̃G[bZ[W
  ElseIf $Type = 1 Then
    If StringLeft($s, 21) = "! LaTeX Error: \begin" Then
      $t = 13
    ElseIf StringLeft($s, 21) = "! LaTeX Error: Can be" Then
      $t = 14
    ElseIf StringLeft($s, 23) = "! LaTeX Error: \caption" Then
      $t = 15
    ElseIf StringLeft($s, 19) = "! LaTeX Error: File" Then
      $t = 16
    ElseIf StringLeft($s, 32) = "! LaTeX Error: Illegal character" Then
      $t = 17
    ElseIf StringLeft($s, 29) = "! LaTeX Error: Missing \begin" Then
      $t = 18
    ElseIf StringLeft($s, 25) = "! LaTeX Error: No counter" Then
      $t = 19
    ElseIf StringLeft($s, 29) = "! LaTeX Error: Unknown option" Then
      $t = 20
    EndIf
  EndIf
  If $t >= 0 Then
    Return $TranslationMessage[$t] & $NL2
  Else
    Return ""
  EndIf
EndFunc
