;;;;;;;;;;
; Grading
;;;;;;;;;;

$Version = "1.0"

; 2dN̋֎~
$List = ProcessList("Grading.exe")
If $List[0][0] > 1 Then Exit

If $CmdLine[0] = 0 Then
  MsgBox(0, "Grading.exe Ver " & $Version & "  by  ", "f[^t@C Grading.exe ̃ACR" & @CRLF & "hbOhbvĂD")
  Exit
EndIf

$DataFile = $CmdLine[1]
If StringRight($DataFile, 4) <> ".txt" Then
  MsgBox(0, "Grading.exe Ver " & $Version & "  by  ", "f[^t@C̊gq .txt ɂĂD")
  Exit
EndIf

$ResultFile = StringTrimRight($DataFile, 4)
$SortedFileWithoutCalc = $ResultFile & "_Sorted.txt"
If StringRight($ResultFile, 7) <> "_Result" Then $ResultFile &= "_Result"
$SortedFile = $ResultFile & "_Sorted.txt"
$ResultFile &= ".txt"

#include <GUIConstantsEx.au3>
#include <ButtonConstants.au3>
#include <Array.au3>

Global $Mode, $RealSymbolA, $RealSymbolB, $RealSymbolC, $RealSymbolD, $RealSymbolE, $RealSymbolJ
$DefaultWidth = 4
Dim $Symbols[7]  = ["S / A / B / C / F", "A / B / C / D / F", "G/D///s", "D///s", "(4)/(3)/(2)/(1)/(0)", "(5)/(4)/(3)/(2)/(1)", "10 iK (10) ` (1)"]
$Symb = $Symbols[0]
For $i = 1 To 6
  $Symb &= "|" & $Symbols[$i]
Next

$ScriptDir = @ScriptDir
If StringLen($ScriptDir) > 3 Then $ScriptDir &= "\"
$IniFile = $ScriptDir & "Grading.ini"
$Width = IniRead($IniFile, "Grading", "Width", "")
$Type = IniRead($IniFile, "Grading", "Type", "")
$Encoding = IniRead($IniFile, "Grading", "Encoding", "")
If $Width = "" Then $Width = $DefaultWidth
If $Type = "" Then $Type = 1
If $Encoding = "Shift_JIS" Then
  $WritingMode = 2
Else
  $WritingMode = 2 + 256
EndIf

$File = FileOpen($DataFile, 0)
$Data = FileRead($File)
FileClose($File)
$Lines = StringSplit($Data, @CRLF, 1)
$Last = $Lines[0]
If $Lines[$Last] = "" Then
  $Last -= 1
  $LastCRLF = True
Else
  $LastCRLF = False
EndIf

GUICreate("ѕ]", 350, 380)
GuiCtrlCreateGroup("Xebv 1@WvE\[g", 10, 15, 330, 110)
GUICtrlCreateLabel("v̕\", 30, 39, 100)
GUICtrlCreateLabel("i0 ȏ̐lj", 30, 59, 100)
GUICtrlCreateLabel("i0 ̓^uj", 30, 79, 100)
$Wi = GuiCtrlCreateInput("", 150, 55, 30)
GUICtrlSetData($Wi, $Width)
$Calc = GUICtrlCreateButton("WvE\[g", 220, 55, 100, 21)
$Sort = GUICtrlCreateButton("\[ĝ", 220, 85, 100, 21)
GuiCtrlCreateGroup("Xebv 2@]", 10, 150, 330, 210)
GUICtrlCreateLabel("]L", 30, 174, 55)
$Sy = GUICtrlCreateCombo("", 90, 170, 130)
GUICtrlSetData($Sy, $Symb, $Symbols[$Type])
$SymbolA = GUICtrlCreateLabel("(10)", 50, 209, 30)
$ScA = GuiCtrlCreateInput("", 80, 205, 30)
GUICtrlCreateLabel("ȏ", 120, 209, 30)
$SymbolB = GUICtrlCreateLabel("(9)", 50, 234, 30)
$ScB = GuiCtrlCreateInput("", 80, 230, 30)
GUICtrlCreateLabel("ȏ", 120, 234, 30)
$SymbolC = GUICtrlCreateLabel("(8)", 50, 259, 30)
$ScC = GuiCtrlCreateInput("", 80, 255, 30)
GUICtrlCreateLabel("ȏ", 120, 259, 30)
$SymbolD = GUICtrlCreateLabel("(7)", 50, 284, 30)
$ScD = GuiCtrlCreateInput("", 80, 280, 30)
GUICtrlCreateLabel("ȏ", 120, 284, 30)
$SymbolE = GUICtrlCreateLabel("(6)", 50, 309, 30)
$ScE = GuiCtrlCreateInput("", 80, 305, 30)
GUICtrlCreateLabel("ȏ", 120, 309, 30)
GUICtrlCreateLabel(" (5)", 180, 209, 30)
$ScF = GuiCtrlCreateInput("", 210, 205, 30)
GUICtrlCreateLabel("ȏ", 250, 209, 30)
GUICtrlCreateLabel(" (4)", 180, 234, 30)
$ScG = GuiCtrlCreateInput("", 210, 230, 30)
GUICtrlCreateLabel("ȏ", 250, 234, 30)
GUICtrlCreateLabel(" (3)", 180, 259, 30)
$ScH = GuiCtrlCreateInput("", 210, 255, 30)
GUICtrlCreateLabel("ȏ", 250, 259, 30)
GUICtrlCreateLabel(" (2)", 180, 284, 30)
$ScI = GuiCtrlCreateInput("", 210, 280, 30)
GUICtrlCreateLabel("ȏ", 250, 284, 30)
GUICtrlCreateLabel(" (1)", 180, 309, 30)
SetSymbols()
$Grading = GUICtrlCreateButton("]", 220, 320, 100, 21)
GUICtrlSetState($Calc, $GUI_FOCUS)
GUISetState()
While True
  $Msg = GUIGetMsg()
  Switch $Msg
    Case $Calc
      $TotalWidth = GUICtrlRead($Wi)
      If $TotalWidth = "" OR StringIsInt($TotalWidth) = 0 OR $TotalWidth < 0 Then $TotalWidth = $DefaultWidth
      CalcTotal()
      If $Mode = "Calc" Then ExitLoop
    Case $Sort
      $Mode = "Sort"
      ExitLoop
    Case $Sy
      $CurrentSy = GUICtrlRead($Sy)
      For $i = 0 To 6
        If $CurrentSy = $Symbols[$i] Then ExitLoop
      Next
      $Type = $i
      SetSymbols()
    Case $Grading
      $ScoreA = GUICtrlRead($ScA)
      $ScoreB = GUICtrlRead($ScB)
      $ScoreC = GUICtrlRead($ScC)
      $ScoreD = GUICtrlRead($ScD)
      $ScoreE = GUICtrlRead($ScE)
      $ScoreF = GUICtrlRead($ScF)
      $ScoreG = GUICtrlRead($ScG)
      $ScoreH = GUICtrlRead($ScH)
      $ScoreI = GUICtrlRead($ScI)
      $Mode = "Grading"
      ExitLoop
    Case $GUI_EVENT_CLOSE
      Exit
  EndSwitch
WEnd
GUIDelete()
Switch $Mode
  Case "Grading"
    WriteGrading()
  Case Else
    WriteResult($Mode)
EndSwitch

Exit

; ==========================================================================

Func SetSymbols()
  Switch $Type
    Case 0
      $RealSymbolA = "S"
      $RealSymbolB = "A"
      $RealSymbolC = "B"
      $RealSymbolD = "C"
      $RealSymbolE = "F"
      $RealSymbolJ = "F"
    Case 1
      $RealSymbolA = "A"
      $RealSymbolB = "B"
      $RealSymbolC = "C"
      $RealSymbolD = "D"
      $RealSymbolE = "F"
      $RealSymbolJ = "F"
    Case 2
      $RealSymbolA = "G"
      $RealSymbolB = "D"
      $RealSymbolC = ""
      $RealSymbolD = ""
      $RealSymbolE = "s"
      $RealSymbolJ = "s"
    Case 3
      $RealSymbolA = "D"
      $RealSymbolB = ""
      $RealSymbolC = ""
      $RealSymbolD = "s"
      $RealSymbolE = ""
      $RealSymbolJ = "s"
    Case 4
      $RealSymbolA = "(4)"
      $RealSymbolB = "(3)"
      $RealSymbolC = "(2)"
      $RealSymbolD = "(1)"
      $RealSymbolE = "(0)"
      $RealSymbolJ = "(0)"
    Case 5
      $RealSymbolA = "(5)"
      $RealSymbolB = "(4)"
      $RealSymbolC = "(3)"
      $RealSymbolD = "(2)"
      $RealSymbolE = "(1)"
      $RealSymbolJ = "(1)"
    Case 6
      $RealSymbolA = "(10)"
      $RealSymbolB = " (9)"
      $RealSymbolC = " (8)"
      $RealSymbolD = " (7)"
      $RealSymbolE = " (6)"
      $RealSymbolJ = " (1)"
  EndSwitch
  GUICtrlSetData($SymbolA, $RealSymbolA)
  GUICtrlSetData($SymbolB, $RealSymbolB)
  GUICtrlSetData($SymbolC, $RealSymbolC)
  GUICtrlSetData($SymbolD, $RealSymbolD)
  GUICtrlSetData($SymbolE, $RealSymbolE)
  If $Type = 3 Then
    For $i = 1 To 18
      GUICtrlSetState($SymbolD + $i, $GUI_HIDE)
    Next
  ElseIf $Type < 6 Then
    For $i = 1 To 3
      GUICtrlSetState($SymbolD + $i, $GUI_SHOW)
    Next
    For $i = 4 To 18
      GUICtrlSetState($SymbolD + $i, $GUI_HIDE)
    Next
  Else
    For $i = 1 To 18
      GUICtrlSetState($SymbolD + $i, $GUI_SHOW)
    Next
  EndIf
  GUICtrlSetData($ScA, "")
  GUICtrlSetData($ScB, "")
  GUICtrlSetData($ScC, "")
  GUICtrlSetData($ScD, "")
  GUICtrlSetData($ScE, "")
  GUICtrlSetData($ScF, "")
  GUICtrlSetData($ScG, "")
  GUICtrlSetData($ScH, "")
  GUICtrlSetData($ScI, "")
EndFunc

Func CalcTotal()
  Global $Result = ""
  Global $Array[$Last][2]
  $CalcResult = ""
  $Str = "(^|\s)([+-]?\d+(?:\.\d+)?)(\s|$)"
  $calc_i = 0
  For $i = 1 To $Last
    If StringRegExp($Lines[$i], "^\s*//", 0) = 0 Then
      $s = StringRegExpReplace($Lines[$i], $Str, "$1 $2 $3")
      $t = StringRegExp($s, $Str, 3)
      If @Error = 0 Then
        $Sum = $t[0]
        For $j = 1 To UBound($t) - 1
          $Sum += $t[$j]
        Next
        If $TotalWidth > 0 Then
          $Sp = ""
          $k = StringInStr($Sum & ".", ".")
          For $j = $k To $TotalWidth
            $Sp &= " "
          Next
          $Array[$calc_i][1] = $Lines[$i] & $Sp & $Sum
        Else
          $Array[$calc_i][1] = $Lines[$i] & @TAB & $Sum
        EndIf
        $Array[$calc_i][0] = $Sum
        $Result &= $Array[$calc_i][1]
        $CalcResult &= $Array[$calc_i][1] & @CRLF
        $calc_i += 1
      Else
        $Result &= $Lines[$i]
      EndIf
    Else
      $Result &= $Lines[$i]
    EndIf
    If $i < $Last OR $LastCRLF Then $Result &= @CRLF
  Next
  ReDim $Array[$calc_i][2]
  GUICreate("", 560, 570)
  $ResultArea = GUICtrlCreateEdit($CalcResult, 0, 0, 560, 500)
  GUICtrlSetFont($ResultArea, 9, 400, 0, "lr SVbN")
  $Write = GUICtrlCreateButton("", 65, 520, 100, 30)
  $Back = GUICtrlCreateButton("\̕ύX", 230, 520, 100, 30, $BS_DEFPUSHBUTTON)
  $Abort = GUICtrlCreateButton("I", 395, 520, 100, 30)
  GUICtrlSetState($Back, $GUI_FOCUS)
  GUISetState()
  While True
    $Msg = GUIGetMsg()
    Switch $Msg
      Case $Write
        $Mode = "Calc"
        ExitLoop
      Case $Back
        $Mode = "Continue"
        ExitLoop
      Case $Abort, $GUI_EVENT_CLOSE
        Exit
    EndSwitch
  WEnd
  GUIDelete()
EndFunc

Func WriteResult($s)
  If $s = "Calc" Then
    $File = FileOpen($ResultFile, $WritingMode)
    FileWrite($File, $Result)
    FileClose($File)
  Else
    Dim $Array[$Last][2]
    $Str =  "^((?:|.*\s)([+-]?\d+(?:\.\d+)?))\s*$"
    $j = 0
    For $i = 1 To $Last
      If StringRegExp($Lines[$i], "^\s*//", 0) = 0 Then
        $s = StringRegExp($Lines[$i], $Str, 3)
        If @Error = 0 Then
          $Array[$j][0] = Number($s[1])
          $Array[$j][1] = $s[0]
          $j += 1
        EndIf
      EndIf
    Next
    ReDim $Array[$j][2]
    $SortedFile = $SortedFileWithoutCalc
  EndIf
  _ArraySort($Array, 1, 0, 0, 0)
  $Result = ""
  For $i = 0 To UBound($Array) - 1
    $Result &= $Array[$i][1] & @CRLF
  Next
  $File = FileOpen($SortedFile, $WritingMode)
  FileWrite($File, $Result)
  FileClose($File)
  If $s = "Calc" Then
    IniWrite($IniFile, "Grading", "Width", $TotalWidth)
    MsgBox(0, "", "_Result t@CɍvC" & @CRLF & "_Result_Sorted t@CɃ\[gʂ݂܂D")
  Else
    MsgBox(0, "", "_Sorted t@CɃ\[gʂ݂܂D")
  EndIf
  Exit
EndFunc

Func WriteGrading()
  $Str =  "(?:^|\s)([+-]?\d+(?:\.\d+)?)\s*$"
  $Result = ""
  $NumA = 0
  $NumB = 0
  $NumC = 0
  $NumD = 0
  $NumE = 0
  $NumF = 0
  $NumG = 0
  $NumH = 0
  $NumI = 0
  $NumJ = 0
  For $i = 1 To $Last
    $Result &= $Lines[$i]
    If StringRegExp($Lines[$i], "^\s*//", 0) = 0 Then
      $s = StringRegExp($Lines[$i], $Str, 3)
      If @Error = 0 Then
        $t = Number($s[0])
        Select
          Case $ScoreA <> "" AND $t >= $ScoreA
            $Result &= "  " & $RealSymbolA
            $NumA += 1
          Case $ScoreB <> "" AND $t >= $ScoreB
            $Result &= "    " & $RealSymbolB
            $NumB += 1
          Case $ScoreC <> "" AND $t >= $ScoreC
            $Result &= "      " & $RealSymbolC
            $NumC += 1
          Case $ScoreD <> "" AND $t >= $ScoreD
            $Result &= "        " & $RealSymbolD
            $NumD += 1
          Case Else
            If $Type < 6 Then
              $Result &= "          " & $RealSymbolJ
              $NumJ += 1
            Else
              Select
                Case $ScoreE <> "" AND $t >= $ScoreE
                  $Result &= "          " & $RealSymbolE
                  $NumE += 1
                Case $ScoreF <> "" AND $t >= $ScoreF
                  $Result &= "             (5)"
                  $NumF += 1
                Case $ScoreG <> "" AND $t >= $ScoreG
                  $Result &= "               (4)"
                  $NumG += 1
                Case $ScoreH <> "" AND $t >= $ScoreH
                  $Result &= "                 (3)"
                  $NumH += 1
                Case $ScoreI <> "" AND $t >= $ScoreI
                  $Result &= "                   (2)"
                  $NumI += 1
                Case Else
                  $Result &= "                     (1)"
                  $NumJ += 1
              EndSelect
            EndIf
        EndSelect
      EndIf
    EndIf
    $Result &= @CRLF
  Next
  $Result &= @CRLF
  If $ScoreA <> "" Then $Result &= $RealSymbolA & Reform($ScoreA) & StringFormat("%3d", $NumA) & "l" & @CRLF
  If $ScoreB <> "" Then $Result &= $RealSymbolB & Reform($ScoreB) & StringFormat("%3d", $NumB) & "l" & @CRLF
  If $ScoreC <> "" Then $Result &= $RealSymbolC & Reform($ScoreC) & StringFormat("%3d", $NumC) & "l" & @CRLF
  If $ScoreD <> "" Then $Result &= $RealSymbolD & Reform($ScoreD) & StringFormat("%3d", $NumD) & "l" & @CRLF
  If $ScoreE <> "" Then $Result &= " (6)" & Reform($ScoreE) & StringFormat("%3d", $NumE) & "l" & @CRLF
  If $ScoreF <> "" Then $Result &= " (5)" & Reform($ScoreF) & StringFormat("%3d", $NumF) & "l" & @CRLF
  If $ScoreG <> "" Then $Result &= " (4)" & Reform($ScoreG) & StringFormat("%3d", $NumG) & "l" & @CRLF
  If $ScoreH <> "" Then $Result &= " (3)" & Reform($ScoreH) & StringFormat("%3d", $NumH) & "l" & @CRLF
  If $ScoreI <> "" Then $Result &= " (2)" & Reform($ScoreI) & StringFormat("%3d", $NumI) & "l" & @CRLF
  If $NumJ > 0 Then
    If $Type = 2 OR $Type = 3 Then
      $Result &= $RealSymbolJ & StringFormat("%12d", $NumJ) & "l" & @CRLF
    Else
      $Result &= $RealSymbolJ & StringFormat("%14d", $NumJ) & "l" & @CRLF
    EndIf
  EndIf
  $File = FileOpen($ResultFile, $WritingMode)
  FileWrite($File, $Result)
  FileClose($File)
  IniWrite($IniFile, "Grading", "Type", $Type)
  MsgBox(0, "", "_Result t@Cɕ]݂܂D")
EndFunc

Func Reform($s)
  $Sp1 = ""
  $Sp2 = ""
  $k = StringInStr($s & ".", ".")
  For $j = $k To 5
    $Sp1 &= " "
  Next
  $k = StringLen($s) + 1 - $k
  For $j = $k To 4
    $Sp2 &= " "
  Next
  Return $Sp1 & $s & "-" & $sp2
EndFunc
